/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.domain.internal.product;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.openvpms.component.math.Weight;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.ObjectRelationship;
import org.openvpms.component.model.bean.Policies;
import org.openvpms.component.model.bean.RelatedIMObjects;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.SequencedRelationship;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.internal.product.BaseProductImpl;
import org.openvpms.domain.internal.product.TemplateItemImpl;
import org.openvpms.domain.product.Template;
import org.openvpms.domain.product.TemplateItem;

public class TemplateImpl
extends BaseProductImpl
implements Template {
    private List<TemplateItem> items;

    public TemplateImpl(Product peer, ArchetypeService service) {
        super(peer, service);
    }

    public TemplateImpl(IMObjectBean bean) {
        super(bean);
    }

    public String getVisitNote() {
        return this.getBean().getString("visitNote");
    }

    public List<TemplateItem> getItems() {
        if (this.items == null) {
            ArrayList<TemplateItemImpl> list = new ArrayList<TemplateItemImpl>();
            IMObjectBean bean = this.getBean();
            RelatedIMObjects includes = (RelatedIMObjects)bean.getRelated("includes", Product.class, SequencedRelationship.class).policy(Policies.newPolicy(SequencedRelationship.class).orderBySequence().active().build());
            for (ObjectRelationship included : includes.getObjectRelationships()) {
                list.add(new TemplateItemImpl((Product)included.getObject(), bean.getBean((IMObject)included.getRelationship())));
            }
            this.items = Collections.unmodifiableList(list);
        }
        return this.items;
    }

    public List<TemplateItem> getItems(Weight weight) {
        return this.getItems().stream().filter(item -> item.inWeightRange(weight)).collect(Collectors.toList());
    }
}

