/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.domain.internal.patient.referral;

import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Predicates;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.PeriodRelationship;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.domain.internal.patient.referral.ReferralImpl;
import org.openvpms.domain.patient.referral.Referral;
import org.openvpms.domain.patient.referral.Referrals;

public class ReferralsImpl
implements Referrals {
    private final IMObjectBean bean;
    private final DomainService domainService;

    public ReferralsImpl(IMObjectBean bean, DomainService domainService) {
        this.bean = bean;
        this.domainService = domainService;
    }

    public Referral getCurrent() {
        return this.getReferral(new Date());
    }

    public Referral getReferredFrom() {
        return this.getReferredFrom(false);
    }

    public Referral getReferredFrom(boolean activeOnly) {
        return this.getMostRecent("entityRelationship.referredFrom", activeOnly);
    }

    public Referral getReferredTo() {
        return this.getReferredTo(false);
    }

    public Referral getReferredTo(boolean activeOnly) {
        return this.getMostRecent("entityRelationship.referredTo", activeOnly);
    }

    public Referral getReferral(OffsetDateTime date) {
        return this.getReferral(DateRules.toDate((OffsetDateTime)date));
    }

    public List<Referral> getAll() {
        List<Object> result = Collections.emptyList();
        List relationships = this.bean.getValues("referrals", PeriodRelationship.class);
        if (!relationships.isEmpty()) {
            this.sort(relationships);
            result = relationships.stream().map(relationship -> new ReferralImpl((PeriodRelationship)relationship, this.domainService)).collect(Collectors.toList());
        }
        return result;
    }

    private Referral getMostRecent(String archetype, boolean activeOnly) {
        ReferralImpl result = null;
        Predicate predicate = activeOnly ? Predicates.activeNow().and(Predicates.isA((String[])new String[]{archetype})) : Predicates.isA((String[])new String[]{archetype});
        List relationships = this.bean.getValues("referrals", PeriodRelationship.class, predicate);
        if (!relationships.isEmpty()) {
            this.sort(relationships);
            result = new ReferralImpl((PeriodRelationship)relationships.get(0), this.domainService);
        }
        return result;
    }

    private void sort(List<PeriodRelationship> relationships) {
        if (relationships.size() > 1) {
            relationships.sort(((Comparator)(o1, o2) -> DateRules.compareTo((Date)o1.getActiveStartTime(), (Date)o2.getActiveStartTime())).thenComparingLong(IMObject::getId).reversed());
        }
    }

    private Referral getReferral(Date date) {
        PeriodRelationship relationship = (PeriodRelationship)this.bean.getValue("referrals", PeriodRelationship.class, Predicates.activeAt((Date)date));
        return relationship != null ? new ReferralImpl(relationship, this.domainService) : null;
    }
}

