/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.domain.internal.patient.record.builder;

import java.math.BigDecimal;
import org.openvpms.component.math.WeightUnits;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.domain.internal.patient.record.builder.BuildContext;
import org.openvpms.domain.internal.patient.record.builder.ChildRecordBuilderImpl;
import org.openvpms.domain.internal.service.patient.PatientServices;
import org.openvpms.domain.patient.record.Record;
import org.openvpms.domain.patient.record.WeightRecord;
import org.openvpms.domain.patient.record.builder.RecordBuilder;
import org.openvpms.domain.patient.record.builder.WeightBuilder;

public class WeightBuilderImpl<B extends WeightBuilder<B, P, PB>, P extends Record, PB extends RecordBuilder<P, PB>>
extends ChildRecordBuilderImpl<WeightRecord, B, P, PB>
implements WeightBuilder<B, P, PB> {
    private BigDecimal weight;
    private WeightUnits units;

    public WeightBuilderImpl(PB parent, PatientServices services) {
        super("act.patientWeight", parent, services);
    }

    public B weight(BigDecimal weight, WeightUnits units) {
        this.weight = weight;
        this.units = units;
        return (B)((WeightBuilder)this.getThis());
    }

    @Override
    protected void build(Act object, IMObjectBean bean, BuildContext context) {
        super.build(object, bean, context);
        if (this.weight == null) {
            throw new IllegalStateException("Weight not set");
        }
        if (this.weight.compareTo(BigDecimal.ZERO) <= 0) {
            throw new IllegalStateException("Invalid weight: " + this.weight);
        }
        if (this.units == null) {
            throw new IllegalStateException("Units not set");
        }
        bean.setValue("weight", (Object)this.weight);
        bean.setValue("units", (Object)this.units);
    }
}

