/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.domain.internal.patient.record.builder;

import java.time.OffsetDateTime;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.openvpms.archetype.rules.patient.MedicalRecordRules;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.domain.internal.patient.record.builder.BuildContext;
import org.openvpms.domain.internal.patient.record.builder.ParentRecordBuilderImpl;
import org.openvpms.domain.internal.patient.record.builder.RecordBuilderImpl;
import org.openvpms.domain.internal.patient.record.builder.VisitNoteBuilderImpl;
import org.openvpms.domain.internal.patient.record.builder.VisitWeightBuilderImpl;
import org.openvpms.domain.internal.service.patient.PatientServices;
import org.openvpms.domain.patient.Patient;
import org.openvpms.domain.patient.record.Visit;
import org.openvpms.domain.patient.record.builder.VisitBuilder;
import org.openvpms.domain.patient.record.builder.VisitNoteBuilder;
import org.openvpms.domain.patient.record.builder.VisitWeightBuilder;
import org.openvpms.domain.practice.Location;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class VisitBuilderImpl
extends ParentRecordBuilderImpl<Visit, VisitBuilder>
implements VisitBuilder {
    private final Visit existing;
    private final long existingPatientId;
    private Patient patient;
    private Location location;

    public VisitBuilderImpl(PatientServices services) {
        this((Visit)null, services);
    }

    public VisitBuilderImpl(Visit visit, PatientServices services) {
        super("act.patientClinicalEvent", services);
        this.existing = visit;
        if (visit != null) {
            Patient patient = visit.getPatient();
            this.existingPatientId = patient != null ? patient.getId() : 0L;
            this.patient(patient);
            this.location(visit.getLocation());
        } else {
            this.existingPatientId = 0L;
        }
    }

    @Override
    public Patient getPatient() {
        return this.patient;
    }

    public VisitBuilder patient(Patient patient) {
        this.patient = patient;
        return this;
    }

    public VisitBuilder location(Location location) {
        this.location = location;
        return this;
    }

    public VisitNoteBuilder newNote() {
        return new VisitNoteBuilderImpl(this, this.getServices());
    }

    public VisitWeightBuilder newWeight() {
        return new VisitWeightBuilderImpl(this, this.getServices());
    }

    public Visit build() {
        if (this.patient == null) {
            throw new IllegalStateException("Patient not specified");
        }
        if (this.existingPatientId != 0L && this.patient.getId() != this.existingPatientId) {
            throw new IllegalStateException("Cannot change patient on existing visit");
        }
        final BuildContext context = new BuildContext(this.getArchetypeService());
        Act visit = this.build(context);
        TransactionTemplate template = new TransactionTemplate(this.getServices().getTransactionManager());
        template.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus transactionStatus) {
                context.save();
            }
        });
        return this.existing != null ? this.existing : this.getServices().getDomainService().create(visit, Visit.class);
    }

    @Override
    protected Act getObject() {
        Visit result;
        Patient patient = this.getPatient();
        if (this.existing != null) {
            IMObjectBean bean = this.getBean((IMObject)this.existing);
            Reference patientRef = bean.getTargetRef("patient");
            if (patient != null) {
                if (!Objects.equals(patient.getObjectReference(), patientRef)) {
                    throw new IllegalStateException("Mismatched patients");
                }
            } else {
                patient = (Patient)this.getServices().getDomainService().get(patientRef, Patient.class);
                if (patient == null) {
                    throw new IllegalStateException("Patient not found: " + patientRef);
                }
                this.patient(patient);
            }
            result = this.existing;
        } else {
            OffsetDateTime date = this.getDate();
            Date startTime = date != null ? DateRules.toDate((OffsetDateTime)date) : new Date();
            MedicalRecordRules rules = this.getServices().getMedicalRecordRules();
            result = rules.getEventForAddition((Party)patient, startTime, null, (Party)this.location);
        }
        return result;
    }

    @Override
    protected void build(Act object, IMObjectBean bean, BuildContext context) {
        List<RecordBuilderImpl<?, ?>> builders;
        super.build(object, bean, context);
        if (this.location != null) {
            bean.setTarget("location", (IMObject)this.location);
        }
        if (!(builders = this.getBuilders()).isEmpty()) {
            context.addChange((IMObject)object);
            for (RecordBuilderImpl<?, ?> builder : builders) {
                Act child = builder.build(context);
                bean.addTarget("items", (IMObject)child, "event");
                context.addChange((IMObject)child);
            }
        }
    }
}

