/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.domain.internal.patient.record.builder;

import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Selection;
import org.joda.time.Period;
import org.openvpms.archetype.rules.patient.MedicalRecordRules;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActIdentity;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.user.User;
import org.openvpms.component.query.criteria.CriteriaBuilder;
import org.openvpms.component.query.criteria.CriteriaQuery;
import org.openvpms.component.query.criteria.Join;
import org.openvpms.component.query.criteria.Root;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.internal.patient.record.builder.BuildContext;
import org.openvpms.domain.internal.service.patient.PatientServices;
import org.openvpms.domain.patient.Patient;
import org.openvpms.domain.patient.record.Record;
import org.openvpms.domain.patient.record.builder.RecordBuilder;

public abstract class RecordBuilderImpl<R extends Record, RB extends RecordBuilder<R, RB>>
implements RecordBuilder<R, RB> {
    private final String archetype;
    private final PatientServices services;
    private OffsetDateTime date;
    private User clinician;
    private final List<ActIdentity> identities = new ArrayList<ActIdentity>();

    public RecordBuilderImpl(String archetype, PatientServices services) {
        this.archetype = archetype;
        this.services = services;
    }

    public abstract Patient getPatient();

    public OffsetDateTime getDate() {
        return this.date;
    }

    public RB date(OffsetDateTime date) {
        this.date = date;
        return this.getThis();
    }

    public User getClinician() {
        return this.clinician;
    }

    public RB clinician(User clinician) {
        this.clinician = clinician;
        return this.getThis();
    }

    public RB addIdentity(String archetype, String identity) {
        ActIdentity id = this.create(archetype, ActIdentity.class);
        id.setIdentity(identity);
        this.identities.add(id);
        return this.getThis();
    }

    public Act build(BuildContext context) {
        Act object = this.getObject();
        this.build(object, this.getBean((IMObject)object), context);
        return object;
    }

    protected void build(Act object, IMObjectBean bean, BuildContext context) {
        if (object.isNew()) {
            bean.setValue("startTime", (Object)DateRules.toDate((OffsetDateTime)this.date));
            Patient patient = this.getPatient();
            bean.setTarget("patient", (IMObject)patient);
            context.addChange((IMObject)object);
        } else {
            this.checkLock(object);
        }
        if (!this.identities.isEmpty()) {
            for (ActIdentity identity : this.identities) {
                this.checkIdentity(identity, object);
                object.addIdentity(identity);
            }
            context.addChange((IMObject)object);
            this.identities.clear();
        }
    }

    protected Act getObject() {
        return (Act)this.getArchetypeService().create(this.archetype, Act.class);
    }

    protected <T extends IMObject> T create(String archetype, Class<T> type) {
        return (T)this.getArchetypeService().create(archetype, type);
    }

    protected IMObjectBean getBean(IMObject object) {
        return this.getArchetypeService().getBean(object);
    }

    protected RB getThis() {
        return (RB)this;
    }

    protected ArchetypeService getArchetypeService() {
        return this.services.getArchetypeService();
    }

    protected PatientServices getServices() {
        return this.services;
    }

    protected void checkLock(Act object) {
        if (this.isLocked(object)) {
            throw new IllegalStateException("Cannot modify locked object: " + object.getObjectReference());
        }
    }

    protected boolean isLocked(Act record) {
        MedicalRecordRules recordRules;
        Period period;
        boolean locked = "POSTED".equals(record.getStatus());
        if (!locked && (period = this.services.getPracticeService().getRecordLockPeriod()) != null && (recordRules = this.services.getMedicalRecordRules()).needsLock(record, period)) {
            locked = true;
        }
        return locked;
    }

    private void checkIdentity(ActIdentity identity, Act record) {
        for (ActIdentity existing : record.getIdentities()) {
            if (!existing.getIdentity().equals(identity.getIdentity()) || !existing.getArchetype().equals(identity.getArchetype())) continue;
            throw new IllegalStateException("Duplicate identity: " + identity.getArchetype() + ":" + identity.getIdentity());
        }
        ArchetypeService service = this.getArchetypeService();
        CriteriaBuilder builder = service.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Long.class);
        Root from = query.from(Act.class, new String[]{record.getArchetype()});
        query.select((Selection)from.get("id"));
        Join identities = from.join("identities", identity.getArchetype());
        identities.on((Expression)builder.equal((Expression)identities.get("identity"), (Object)identity.getIdentity()));
        Long id = (Long)service.createQuery(query).getFirstResult();
        if (id != null) {
            throw new IllegalStateException("Duplicate identity: " + identity.getArchetype() + ":" + identity.getIdentity() + " found on record " + id);
        }
    }
}

