/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.domain.internal.patient.record;

import org.openvpms.component.business.domain.im.act.BeanActDecorator;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBeanFactory;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.user.User;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.domain.patient.Patient;
import org.openvpms.domain.patient.record.Record;

public abstract class AbstractRecordImpl
extends BeanActDecorator
implements Record {
    private final DomainService service;

    protected AbstractRecordImpl(Act peer, DomainService service) {
        super(peer, (IMObjectBeanFactory)service);
        this.service = service;
    }

    public Patient getPatient() {
        IMObject patient = this.getBean().getTarget("patient");
        if (patient == null) {
            throw new IllegalStateException("Record has no patient");
        }
        return this.service.create(patient, Patient.class);
    }

    public User getClinician() {
        IMObject clinician = this.getBean().getTarget("clinician");
        return clinician != null ? this.service.create(clinician, User.class) : null;
    }

    public boolean isLocked() {
        return "POSTED".equals(this.getStatus());
    }

    protected DomainService getService() {
        return this.service;
    }
}

