/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.domain.internal.laboratory;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import org.openvpms.component.business.domain.im.common.BeanEntityDecorator;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.IMObjectBeanFactory;
import org.openvpms.component.model.bean.Predicates;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.query.criteria.CriteriaBuilder;
import org.openvpms.component.query.criteria.CriteriaQuery;
import org.openvpms.component.query.criteria.Join;
import org.openvpms.component.query.criteria.Root;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.domain.laboratory.Device;
import org.openvpms.domain.laboratory.Laboratory;
import org.openvpms.domain.laboratory.Test;
import org.openvpms.domain.practice.Location;

public class LaboratoryImpl
extends BeanEntityDecorator
implements Laboratory {
    private final ArchetypeService service;
    private final DomainService domainService;

    public LaboratoryImpl(Entity object, ArchetypeService service, DomainService domainService) {
        super(object, (IMObjectBeanFactory)service);
        this.service = service;
        this.domainService = domainService;
    }

    public List<Location> getLocations() {
        ArrayList<Location> result = new ArrayList<Location>();
        IMObjectBean bean = this.getBean();
        for (Entity entity : bean.getTargets("locations", Entity.class)) {
            result.add(this.domainService.create(entity, Location.class));
        }
        return result;
    }

    public List<Device> getDevices(boolean activeOnly) {
        ArrayList<Device> result = new ArrayList<Device>();
        for (Entity entity : this.query("entity.laboratoryDevice", activeOnly, "laboratory")) {
            result.add(this.domainService.create(entity, Device.class));
        }
        return result;
    }

    public List<Test> getTests(boolean activeOnly) {
        ArrayList<Test> result = new ArrayList<Test>();
        for (Entity entity : this.query("entity.laboratoryTest", activeOnly, "laboratories")) {
            result.add(this.domainService.create(entity, Test.class));
        }
        return result;
    }

    public IMObject getConfiguration(Location location) {
        return this.getBean().getValue("locations", Relationship.class, Predicates.targetEquals((IMObject)location));
    }

    private List<Entity> query(String archetype, boolean activeOnly, String node) {
        CriteriaBuilder builder = this.service.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Entity.class);
        Root root = query.from(Entity.class, new String[]{archetype});
        Join laboratories = root.join(node);
        laboratories.on((Expression)builder.equal((Expression)laboratories.get("target"), (Object)this.getId()));
        if (activeOnly) {
            query.where((Expression)builder.equal((Expression)root.get("active"), (Object)true));
        }
        query.orderBy(new Order[]{builder.asc((Expression)root.get("id"))});
        return this.service.createQuery(query).getResultList();
    }
}

