/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.domain.internal.builder;

import org.apache.commons.lang.ObjectUtils;
import org.openvpms.component.model.bean.IMObjectBean;

public class NodeValue {
    private final String name;
    private Object value;
    private boolean set;

    public NodeValue(String name) {
        this.name = name;
    }

    public NodeValue(String name, Object value) {
        this(name);
        this.setValue(value);
    }

    public String getName() {
        return this.name;
    }

    public void setValue(Object value) {
        this.value = value;
        this.set = true;
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        return this.value != null ? this.value.toString() : null;
    }

    public boolean isSet() {
        return this.set;
    }

    public void reset() {
        this.value = null;
        this.set = false;
    }

    public boolean update(IMObjectBean bean) {
        boolean result = false;
        if (this.set) {
            result = this.update(bean, this.value);
        }
        return result;
    }

    public boolean update(IMObjectBean bean, Object value) {
        boolean result = false;
        Object existing = bean.getValue(this.name);
        if (!ObjectUtils.equals((Object)existing, (Object)value)) {
            bean.setValue(this.name, value);
            result = true;
        }
        return result;
    }

    public boolean getBoolean(IMObjectBean bean) {
        return bean.getBoolean(this.name);
    }
}

