/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.domain.internal.service.product;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.archetype.test.builder.product.TestMedicationProductBuilder;
import org.openvpms.archetype.test.builder.product.TestMerchandiseProductBuilder;
import org.openvpms.archetype.test.builder.product.TestProductFactory;
import org.openvpms.archetype.test.builder.product.TestServiceProductBuilder;
import org.openvpms.archetype.test.builder.product.TestTemplateProductBuilder;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.domain.internal.service.product.ProductsImpl;
import org.openvpms.domain.service.product.MedicationQuery;
import org.openvpms.domain.service.product.MerchandiseQuery;
import org.openvpms.domain.service.product.ProductQuery;
import org.openvpms.domain.service.product.Products;
import org.openvpms.domain.service.product.ServiceQuery;
import org.openvpms.domain.service.product.TemplateQuery;
import org.springframework.beans.factory.annotation.Autowired;

public class ProductsImplTestCase
extends ArchetypeServiceTest {
    @Autowired
    private TestProductFactory productFactory;
    @Autowired
    private DomainService domainService;
    private Products products;

    @Before
    public void setUp() {
        this.products = new ProductsImpl((ArchetypeService)this.getArchetypeService(), this.domainService);
    }

    @Test
    public void testGetProduct() {
        Product medication = this.productFactory.createMedication();
        Product merchandise = this.productFactory.createMerchandise();
        Product service = this.productFactory.createService();
        Product template = this.productFactory.createTemplate();
        Assert.assertEquals((Object)medication, (Object)this.products.getProduct(medication.getId()));
        Assert.assertEquals((Object)merchandise, (Object)this.products.getProduct(merchandise.getId()));
        Assert.assertEquals((Object)service, (Object)this.products.getProduct(service.getId()));
        Assert.assertEquals((Object)template, (Object)this.products.getProduct(template.getId()));
    }

    @Test
    public void testQuery() {
        Entity productType1 = this.productFactory.createProductType();
        Entity productType2 = this.productFactory.createProductType();
        Product medication = (Product)((TestMedicationProductBuilder)((TestMedicationProductBuilder)this.productFactory.newMedication().name(ValueStrategy.random())).type(productType1)).build();
        Product merchandise = (Product)((TestMerchandiseProductBuilder)((TestMerchandiseProductBuilder)this.productFactory.newMerchandise().name(ValueStrategy.random())).type(productType2)).build();
        Product service = (Product)((TestServiceProductBuilder)((TestServiceProductBuilder)this.productFactory.newService().name(ValueStrategy.random())).type(productType2)).build();
        Product template = (Product)((TestTemplateProductBuilder)this.productFactory.newTemplate().name(ValueStrategy.random())).build();
        ProductQuery query1 = (ProductQuery)this.products.getQuery().productType(productType1.getName());
        TestHelper.assertIncluded((Iterable)query1.query(), (Object[])new Product[]{medication});
        TestHelper.assertExcluded((Iterable)query1.query(), (Object[])new Product[]{merchandise, service, template});
        ProductQuery query2 = (ProductQuery)this.products.getQuery().productType(productType2.getName());
        TestHelper.assertIncluded((Iterable)query2.query(), (Object[])new Product[]{merchandise, service});
        TestHelper.assertExcluded((Iterable)query2.query(), (Object[])new Product[]{medication, template});
        ProductQuery query3 = (ProductQuery)this.products.getQuery().id(medication.getId());
        TestHelper.assertIncluded((Iterable)query3.query(), (Object[])new Product[]{medication});
        TestHelper.assertExcluded((Iterable)query3.query(), (Object[])new Product[]{merchandise, service, template});
        ProductQuery query4 = (ProductQuery)this.products.getQuery().name(medication.getName());
        TestHelper.assertIncluded((Iterable)query4.query(), (Object[])new Product[]{medication});
        TestHelper.assertExcluded((Iterable)query4.query(), (Object[])new Product[]{merchandise, service, template});
        MedicationQuery query5 = this.products.getQuery().medications();
        TestHelper.assertIncluded((Iterable)query5.query(), (Object[])new Product[]{medication});
        TestHelper.assertExcluded((Iterable)query5.query(), (Object[])new Product[]{merchandise, service, template});
        MerchandiseQuery query6 = this.products.getQuery().merchandise();
        TestHelper.assertIncluded((Iterable)query6.query(), (Object[])new Product[]{merchandise});
        TestHelper.assertExcluded((Iterable)query6.query(), (Object[])new Product[]{medication, service, template});
        ServiceQuery query7 = this.products.getQuery().services();
        TestHelper.assertIncluded((Iterable)query7.query(), (Object[])new Product[]{service});
        TestHelper.assertExcluded((Iterable)query7.query(), (Object[])new Product[]{medication, merchandise, template});
        TemplateQuery query8 = this.products.getQuery().templates();
        TestHelper.assertIncluded((Iterable)query8.query(), (Object[])new Product[]{template});
        TestHelper.assertExcluded((Iterable)query8.query(), (Object[])new Product[]{medication, merchandise, service});
    }

    @Test
    public void testGetBatch() {
        Product medication = this.productFactory.createMedication();
        Assert.assertNull((Object)this.products.getBatch(medication, "123456"));
        Entity batch = (Entity)this.productFactory.newBatch().product(medication).batchNo("123456").build();
        Assert.assertEquals((Object)batch, (Object)this.products.getBatch(medication, "123456"));
    }
}

