/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.domain.internal.service.patient;

import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.builder.lookup.TestLookupFactory;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.party.Party;
import org.openvpms.domain.internal.service.patient.PatientServices;
import org.openvpms.domain.internal.service.patient.PatientsImpl;
import org.openvpms.domain.patient.Patient;
import org.springframework.beans.factory.annotation.Autowired;

public class PatientsImplTestCase
extends ArchetypeServiceTest {
    @Autowired
    private PatientServices patientServices;
    @Autowired
    private TestPatientFactory patientFactory;
    @Autowired
    private TestLookupFactory lookupFactory;

    @Test
    public void testGetPatient() {
        PatientsImpl patients = new PatientsImpl(this.patientServices);
        Party party = this.patientFactory.createPatient();
        Patient patient1 = patients.getPatient(party.getId());
        Assert.assertNotNull((Object)patient1);
        Assert.assertEquals((Object)party, (Object)patient1);
        Patient patient2 = patients.getPatient(0L);
        Assert.assertNull((Object)patient2);
    }

    @Test
    public void testCreateNewPatient() {
        PatientsImpl patients = new PatientsImpl(this.patientServices);
        Lookup species = this.lookupFactory.getSpecies("CANINE");
        Lookup breed = this.lookupFactory.getBreed("KELPIE");
        Patient patient = patients.getPatientBuilder().name("Fido").species(species).breed(breed).build();
        Assert.assertEquals((Object)"Fido", (Object)patient.getName());
        Assert.assertEquals((Object)species.getCode(), (Object)patient.getSpeciesCode());
        Assert.assertEquals((Object)breed.getCode(), (Object)patient.getBreedCode());
    }

    @Test
    public void testUpdatePatient() {
        PatientsImpl patients = new PatientsImpl(this.patientServices);
        Lookup species = this.lookupFactory.getSpecies("CANINE");
        Lookup breed = this.lookupFactory.getBreed("KELPIE");
        Patient patient = patients.getPatientBuilder().name("Fido").species(species).breed(breed).build();
        patients.getPatientBuilder(patient).name("Spot").build();
        Assert.assertEquals((Object)"Spot", (Object)patient.getName());
    }
}

