/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.domain.internal.service.customer;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.party.CustomerRules;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.customer.Customer;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.domain.internal.service.customer.CustomersImpl;
import org.springframework.beans.factory.annotation.Autowired;

public class CustomersImplTestCase
extends ArchetypeServiceTest {
    @Autowired
    private CustomerRules rules;
    @Autowired
    private DomainService domainObjectService;
    @Autowired
    private TestCustomerFactory customerFactory;
    private CustomersImpl customers;

    @Before
    public void setUp() {
        this.customers = new CustomersImpl(this.rules, (ArchetypeService)this.getArchetypeService(), this.domainObjectService, this.getLookupService());
    }

    @Test
    public void testGetCustomer() {
        Party party = this.customerFactory.createCustomer();
        Customer customer1 = this.customers.getCustomer(party.getId());
        Assert.assertNotNull((Object)customer1);
        Assert.assertEquals((Object)party, (Object)customer1);
        Customer customer2 = this.customers.getCustomer(0L);
        Assert.assertNull((Object)customer2);
    }

    @Test
    public void testBuildNewCustomer() {
        Customer customer = this.customers.getCustomerBuilder().firstName("J").lastName("Smith").build();
        Assert.assertEquals((Object)"J", (Object)customer.getFirstName());
        Assert.assertEquals((Object)"Smith", (Object)customer.getLastName());
    }

    @Test
    public void testUpdateCustomer() {
        Customer customer = this.customers.getCustomerBuilder().firstName("J").lastName("Smith").build();
        this.customers.getCustomerBuilder(customer).firstName("Jo").lastName("Smyth").build();
        Assert.assertEquals((Object)"Jo", (Object)customer.getFirstName());
        Assert.assertEquals((Object)"Smyth", (Object)customer.getLastName());
    }
}

