/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.domain.internal.patient.record;

import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.domain.internal.patient.record.builder.VisitBuilderImpl;
import org.openvpms.domain.internal.service.patient.PatientServices;
import org.openvpms.domain.patient.Patient;
import org.openvpms.domain.patient.record.Visit;
import org.openvpms.domain.patient.record.builder.VisitBuilder;
import org.openvpms.domain.practice.Location;
import org.springframework.beans.factory.annotation.Autowired;

public class VisitBuilderImplTestCase
extends ArchetypeServiceTest {
    @Autowired
    private DomainService domainService;
    @Autowired
    private PatientServices patientServices;
    @Autowired
    private TestPatientFactory patientFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;

    @Test
    public void testCreateVisit() {
        Patient patient1 = (Patient)this.domainService.create((IMObject)this.patientFactory.createPatient(), Patient.class);
        Patient patient2 = (Patient)this.domainService.create((IMObject)this.patientFactory.createPatient(), Patient.class);
        Location location1 = (Location)this.domainService.create((IMObject)this.practiceFactory.createLocation(), Location.class);
        Date today = DateRules.getToday();
        Visit visit1 = ((VisitBuilder)new VisitBuilderImpl(this.patientServices).patient(patient1).date(DateRules.toOffsetDateTime((Date)today))).location(location1).build();
        this.checkVisit(visit1, patient1, today, location1);
        Visit visit2 = ((VisitBuilder)new VisitBuilderImpl(this.patientServices).patient(patient2).date(DateRules.toOffsetDateTime((Date)today))).location(null).build();
        this.checkVisit(visit2, patient2, today, null);
    }

    @Test
    public void testSameVisitUsedForVisitOnSuccessiveDays() {
        Date today = DateRules.getToday();
        Date date1 = DateRules.getDate((Date)today, (int)-2, (DateUnits)DateUnits.DAYS);
        Date date2 = DateRules.getYesterday();
        VisitBuilderImpl builder = new VisitBuilderImpl(this.patientServices);
        Patient patient = (Patient)this.domainService.create((IMObject)this.patientFactory.createPatient(), Patient.class);
        Location location1 = (Location)this.domainService.create((IMObject)this.practiceFactory.createLocation(), Location.class);
        Visit visit1 = ((VisitBuilder)builder.patient(patient).date(DateRules.toOffsetDateTime((Date)date1))).location(location1).build();
        Visit visit2 = ((VisitBuilder)builder.patient(patient).date(DateRules.toOffsetDateTime((Date)date2))).location(location1).build();
        Assert.assertEquals((Object)visit1, (Object)visit2);
        this.checkVisit(visit1, patient, date1, location1);
        this.checkVisit(visit2, patient, date1, location1);
    }

    @Test
    public void testDifferentVisitAtDifferentLocationsOnSuccessiveDays() {
        Date today = DateRules.getToday();
        Date date1 = DateRules.getDate((Date)today, (int)-2, (DateUnits)DateUnits.DAYS);
        Date date2 = DateRules.getYesterday();
        VisitBuilderImpl builder = new VisitBuilderImpl(this.patientServices);
        Patient patient = (Patient)this.domainService.create((IMObject)this.patientFactory.createPatient(), Patient.class);
        Location location1 = (Location)this.domainService.create((IMObject)this.practiceFactory.createLocation(), Location.class);
        Visit visit1 = ((VisitBuilder)builder.patient(patient).date(DateRules.toOffsetDateTime((Date)date1))).location(location1).build();
        Location location2 = (Location)this.domainService.create((IMObject)this.practiceFactory.createLocation(), Location.class);
        Visit visit2 = ((VisitBuilder)builder.patient(patient).date(DateRules.toOffsetDateTime((Date)date2))).location(location2).build();
        Assert.assertNotEquals((Object)visit1, (Object)visit2);
        this.checkVisit(visit1, patient, date1, location1);
        this.checkVisit(visit2, patient, date2, location2);
    }

    private void checkVisit(Visit visit, Patient patient, Date date, Location location) {
        Assert.assertEquals((Object)patient, (Object)visit.getPatient());
        Assert.assertEquals((Object)date, (Object)visit.getActivityStartTime());
        Assert.assertEquals((Object)location, (Object)visit.getLocation());
        Assert.assertEquals((Object)"IN_PROGRESS", (Object)visit.getStatus());
    }
}

