/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.domain.internal.patient.record;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.builder.laboratory.TestLaboratoryFactory;
import org.openvpms.archetype.test.builder.patient.TestInvestigationBuilder;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.domain.patient.record.DocumentRecord;
import org.openvpms.domain.patient.record.DocumentVersion;
import org.openvpms.domain.patient.record.Investigation;
import org.springframework.beans.factory.annotation.Autowired;

public class InvestigationImplTestCase
extends ArchetypeServiceTest {
    @Autowired
    private TestPatientFactory patientFactory;
    @Autowired
    private TestLaboratoryFactory laboratoryFactory;
    @Autowired
    private DomainService domainService;
    private Investigation investigation;

    @Before
    public void setUp() {
        Party patient = this.patientFactory.createPatient();
        Entity investigationType = this.laboratoryFactory.createInvestigationType();
        DocumentAct act = (DocumentAct)((TestInvestigationBuilder)this.patientFactory.newInvestigation().patient(patient)).investigationType(investigationType).build();
        this.investigation = (Investigation)this.domainService.create((IMObject)act, Investigation.class);
    }

    @Test
    public void testAddDocument() throws IOException {
        Assert.assertNull((Object)this.investigation.getDocument());
        this.investigation.getDocumentBuilder().fileName("some.txt").mimeType("text/plain").content(this.getStream("some text")).build();
        this.checkDocument("some.txt", "some text", (DocumentRecord)this.investigation);
    }

    @Test
    public void testDefaultVersioning() throws IOException {
        Assert.assertNull((Object)this.investigation.getDocument());
        Assert.assertEquals((long)0L, (long)this.investigation.getVersions().getRelationships().size());
        Document document1 = this.investigation.getDocumentBuilder().fileName("doc1.txt").mimeType("text/plain").content(this.getStream("doc 1")).build();
        Document document2 = this.investigation.getDocumentBuilder().fileName("doc2.txt").mimeType("text/plain").content(this.getStream("doc 2")).build();
        Document document3 = this.investigation.getDocumentBuilder().fileName("doc3.txt").mimeType("text/plain").content(this.getStream("doc 3")).build();
        this.checkDocument(document3, "doc3.txt", "doc 3", (DocumentRecord)this.investigation);
        ArrayList<DocumentVersion> versions = new ArrayList<DocumentVersion>();
        this.investigation.getVersions().getObjects().forEach(versions::add);
        Assert.assertEquals((long)2L, (long)versions.size());
        versions.sort(Comparator.comparingLong(IMObject::getId));
        this.checkDocument(document1, "doc1.txt", "doc 1", (DocumentRecord)versions.get(0));
        this.checkDocument(document2, "doc2.txt", "doc 2", (DocumentRecord)versions.get(1));
    }

    @Test
    public void testVersioningDisabled() throws IOException {
        Assert.assertNull((Object)this.investigation.getDocument());
        Assert.assertEquals((long)0L, (long)this.investigation.getVersions().getRelationships().size());
        Document document1 = this.investigation.getDocumentBuilder().fileName("doc1.txt").mimeType("text/plain").content(this.getStream("doc 1")).build();
        Document document2 = this.investigation.getDocumentBuilder().fileName("doc2.txt").mimeType("text/plain").content(this.getStream("doc 2")).version(false).build();
        this.checkDocument(document2, "doc2.txt", "doc 2", (DocumentRecord)this.investigation);
        Assert.assertEquals((long)0L, (long)this.investigation.getVersions().getRelationships().size());
        Assert.assertNull((Object)this.get((IMObject)document1));
    }

    @Test
    public void testVersionProtectedDocument() throws IOException {
        Document document1 = this.investigation.getDocumentBuilder().fileName("doc1.txt").mimeType("text/plain").content(this.getStream("doc 1")).build();
        IMObjectBean bean = this.getBean((IMObject)this.investigation);
        bean.setValue("protectedDocument", (Object)true);
        bean.save();
        Document document2 = this.investigation.getDocumentBuilder().fileName("doc2.txt").mimeType("text/plain").content(this.getStream("doc 2")).version(false).build();
        this.checkDocument(document2, "doc2.txt", "doc 2", (DocumentRecord)this.investigation);
        ArrayList versions = new ArrayList();
        this.investigation.getVersions().getObjects().forEach(versions::add);
        Assert.assertEquals((long)1L, (long)versions.size());
        this.checkDocument(document1, "doc1.txt", "doc 1", (DocumentRecord)versions.get(0));
        Assert.assertFalse((boolean)bean.getBoolean("protectedDocument"));
    }

    private void checkDocument(String fileName, String content, DocumentRecord actual) throws IOException {
        this.checkDocument(null, fileName, content, actual);
    }

    private void checkDocument(Document expected, String fileName, String content, DocumentRecord actual) throws IOException {
        Document document = actual.getDocument();
        if (expected != null) {
            Assert.assertEquals((Object)expected, (Object)document);
        } else {
            Assert.assertNotNull((Object)document);
        }
        Assert.assertEquals((Object)fileName, (Object)document.getName());
        Assert.assertEquals((Object)"text/plain", (Object)document.getMimeType());
        Assert.assertEquals((Object)content, (Object)IOUtils.toString((InputStream)document.getContent(), (Charset)StandardCharsets.UTF_8));
        IMObjectBean bean = this.getBean((IMObject)actual);
        Assert.assertEquals((Object)fileName, (Object)bean.getString("fileName"));
        Assert.assertEquals((Object)"text/plain", (Object)bean.getString("mimeType"));
    }

    private InputStream getStream(String text) {
        return IOUtils.toInputStream((String)text, (Charset)StandardCharsets.UTF_8);
    }
}

