/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.domain.internal.party;

import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.party.CustomerRules;
import org.openvpms.archetype.rules.party.PartyRules;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.builder.customer.TestCustomerBuilder;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.party.TestEmailContactBuilder;
import org.openvpms.archetype.test.builder.party.TestLocationContactBuilder;
import org.openvpms.archetype.test.builder.party.TestPhoneContactBuilder;
import org.openvpms.component.business.domain.im.party.Contact;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.domain.internal.party.ContactablePartyImpl;
import org.openvpms.domain.party.Address;
import org.openvpms.domain.party.Email;
import org.openvpms.domain.party.Phone;
import org.springframework.beans.factory.annotation.Autowired;

public class ContactablePartyImplTestCase
extends ArchetypeServiceTest {
    @Autowired
    private DomainService domainService;
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private CustomerRules rules;

    @Test
    public void testGetContacts() {
        Party customer = (Party)((TestCustomerBuilder)((TestCustomerBuilder)((TestCustomerBuilder)((TestCustomerBuilder)((TestCustomerBuilder)this.customerFactory.newCustomer().addEmail("foo@bar.com", new String[0])).addAddress("1 Smith St", "SALE", "VIC", "3085", new String[0])).addPhone("12345678", new String[0])).addMobilePhone("0412345678")).addWebsite("http://foo.com")).build(false);
        ContactablePartyImpl party = new ContactablePartyImpl(customer, (PartyRules)this.rules, this.domainService);
        Set contacts = party.getContacts();
        Assert.assertEquals((long)5L, (long)contacts.size());
        for (org.openvpms.component.model.party.Contact contact : contacts) {
            if (contact.isA("contact.email")) {
                Assert.assertTrue((boolean)(contact instanceof Email));
                continue;
            }
            if (contact.isA("contact.location")) {
                Assert.assertTrue((boolean)(contact instanceof Address));
                continue;
            }
            if (contact.isA("contact.phoneNumber")) {
                Assert.assertTrue((boolean)(contact instanceof Phone));
                continue;
            }
            if (contact.isA("contact.website")) {
                Assert.assertTrue((boolean)(contact instanceof Contact));
                continue;
            }
            Assert.fail((String)("Unknown contact archetype " + contact.getArchetype()));
        }
    }

    @Test
    public void testGetAddress() {
        Party customer = (Party)((TestCustomerBuilder)((TestCustomerBuilder)((TestCustomerBuilder)((TestCustomerBuilder)((TestCustomerBuilder)this.customerFactory.newCustomer().addEmail("foo@bar.com", new String[0])).addAddress("1 Smith St", "SALE", "VIC", "3085", new String[0])).addPhone("12345678", new String[0])).addMobilePhone("0412345678")).addWebsite("http://foo.com")).build(false);
        ContactablePartyImpl party = new ContactablePartyImpl(customer, (PartyRules)this.rules, this.domainService);
        Address address = party.getAddress();
        Assert.assertNotNull((Object)address);
        Assert.assertEquals((Object)"1 Smith St", (Object)address.getAddress());
        Assert.assertEquals((Object)"SALE", (Object)address.getSuburbCode());
        Assert.assertEquals((Object)"VIC", (Object)address.getStateCode());
        Assert.assertEquals((Object)"3085", (Object)address.getPostcode());
    }

    @Test
    public void testGetAddresses() {
        TestLocationContactBuilder builder = new TestLocationContactBuilder((ArchetypeService)this.getArchetypeService());
        org.openvpms.component.model.party.Contact contact1 = builder.address("Address 1").suburbCode("SALE").stateCode("VIC").postcode("3085").build();
        org.openvpms.component.model.party.Contact contact2 = builder.address("Address 2").build();
        Party customer = (Party)((TestCustomerBuilder)((TestCustomerBuilder)this.customerFactory.newCustomer().addEmail("foo@bar.com", new String[0])).addContact(contact1)).build();
        customer.addContact(contact2);
        this.save((IMObject)customer);
        ContactablePartyImpl party = new ContactablePartyImpl(customer, (PartyRules)this.rules, this.domainService);
        List addresses = party.getAddresses();
        Assert.assertEquals((long)2L, (long)addresses.size());
        Assert.assertEquals((Object)"Address 1", (Object)((Address)addresses.get(0)).getAddress());
        Assert.assertEquals((Object)"Address 2", (Object)((Address)addresses.get(1)).getAddress());
    }

    @Test
    public void testGetPhone() {
        Party customer = (Party)((TestCustomerBuilder)((TestCustomerBuilder)((TestCustomerBuilder)((TestCustomerBuilder)this.customerFactory.newCustomer().addEmail("foo@bar.com", new String[0])).addAddress("1 Smith St", "SALE", "VIC", "3085", new String[0])).addPhone("12345678", new String[0])).addWebsite("http://foo.com")).build(false);
        ContactablePartyImpl party = new ContactablePartyImpl(customer, (PartyRules)this.rules, this.domainService);
        Phone phone = party.getPhone();
        Assert.assertNotNull((Object)phone);
        Assert.assertEquals((Object)"12345678", (Object)phone.getPhoneNumber());
    }

    @Test
    public void testGetPhones() {
        TestPhoneContactBuilder builder = new TestPhoneContactBuilder((ArchetypeService)this.getArchetypeService());
        org.openvpms.component.model.party.Contact contact1 = builder.phone("12345678").build();
        org.openvpms.component.model.party.Contact contact2 = ((TestPhoneContactBuilder)builder.phone("04987654").purposes(new String[]{"MOBILE"})).build();
        Party customer = (Party)((TestCustomerBuilder)((TestCustomerBuilder)((TestCustomerBuilder)((TestCustomerBuilder)this.customerFactory.newCustomer().addEmail("foo@bar.com", new String[0])).addAddress("1 Smith St", "SALE", "VIC", "3085", new String[0])).addContact(contact1)).addWebsite("http://foo.com")).build();
        customer.addContact(contact2);
        this.save((IMObject)customer);
        ContactablePartyImpl party = new ContactablePartyImpl(customer, (PartyRules)this.rules, this.domainService);
        List phones = party.getPhones();
        Assert.assertEquals((long)2L, (long)phones.size());
        Phone phone1 = (Phone)phones.get(0);
        Assert.assertEquals((Object)"12345678", (Object)phone1.getPhoneNumber());
        Assert.assertFalse((boolean)phone1.isMobile());
        Assert.assertFalse((boolean)phone1.isFax());
        Phone phone2 = (Phone)phones.get(1);
        Assert.assertEquals((Object)"04987654", (Object)phone2.getPhoneNumber());
        Assert.assertTrue((boolean)phone2.isMobile());
        Assert.assertFalse((boolean)phone2.isFax());
    }

    @Test
    public void testGetEmail() {
        Party customer = (Party)((TestCustomerBuilder)((TestCustomerBuilder)((TestCustomerBuilder)((TestCustomerBuilder)((TestCustomerBuilder)this.customerFactory.newCustomer().addEmail("foo@bar.com", new String[0])).addAddress("1 Smith St", "SALE", "VIC", "3085", new String[0])).addPhone("12345678", new String[0])).addMobilePhone("0412345678")).addWebsite("http://foo.com")).build(false);
        ContactablePartyImpl party = new ContactablePartyImpl(customer, (PartyRules)this.rules, this.domainService);
        Email email = party.getEmail();
        Assert.assertNotNull((Object)email);
        Assert.assertEquals((Object)"foo@bar.com", (Object)email.getEmailAddress());
    }

    @Test
    public void testGetEmails() {
        TestEmailContactBuilder builder = new TestEmailContactBuilder((ArchetypeService)this.getArchetypeService());
        org.openvpms.component.model.party.Contact contact1 = builder.email("foo@bar.com").build();
        org.openvpms.component.model.party.Contact contact2 = builder.email("foo@gmail.com").build();
        Party customer = (Party)((TestCustomerBuilder)((TestCustomerBuilder)((TestCustomerBuilder)((TestCustomerBuilder)((TestCustomerBuilder)this.customerFactory.newCustomer().addContact(contact1)).addAddress("1 Smith St", "SALE", "VIC", "3085", new String[0])).addPhone("12345678", new String[0])).addMobilePhone("0412345678")).addWebsite("http://foo.com")).build();
        customer.addContact(contact2);
        this.save((IMObject)customer);
        ContactablePartyImpl party = new ContactablePartyImpl(customer, (PartyRules)this.rules, this.domainService);
        List emails = party.getEmails();
        Assert.assertEquals((long)2L, (long)emails.size());
        Assert.assertEquals((Object)"foo@bar.com", (Object)((Email)emails.get(0)).getEmailAddress());
        Assert.assertEquals((Object)"foo@gmail.com", (Object)((Email)emails.get(1)).getEmailAddress());
    }
}

