/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.domain.internal.party;

import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.party.PartyRules;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.builder.lookup.TestCountryBuilder;
import org.openvpms.archetype.test.builder.lookup.TestLookupFactory;
import org.openvpms.archetype.test.builder.party.TestLocationContactBuilder;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.domain.internal.party.AddressImpl;
import org.springframework.beans.factory.annotation.Autowired;

public class AddressImplTestCase
extends ArchetypeServiceTest {
    @Autowired
    private PartyRules partyRules;
    @Autowired
    private DomainService service;
    @Autowired
    private TestLookupFactory lookupFactory;

    @Test
    public void testAddress() {
        TestLocationContactBuilder builder = new TestLocationContactBuilder((ArchetypeService)this.getArchetypeService());
        Contact contact = (Contact)builder.address("1234 Main Rd").suburb("KONGWAK", "Kongwak").state("VIC", "Victoria").postcode("9876").build(false);
        AddressImpl address = new AddressImpl(contact, this.partyRules, this.service);
        Assert.assertEquals((Object)"1234 Main Rd", (Object)address.getAddress());
        Assert.assertEquals((Object)"KONGWAK", (Object)address.getSuburbCode());
        Assert.assertEquals((Object)"Kongwak", (Object)address.getSuburbName());
        Assert.assertNotNull((Object)address.getSuburbLookup());
        Assert.assertEquals((Object)"KONGWAK", (Object)address.getSuburbLookup().getCode());
        Assert.assertEquals((Object)"VIC", (Object)address.getStateCode());
        Assert.assertEquals((Object)"Victoria", (Object)address.getStateName());
        Assert.assertNotNull((Object)address.getStateLookup());
        Assert.assertEquals((Object)"VIC", (Object)address.getStateLookup().getCode());
        Assert.assertEquals((Object)"9876", (Object)address.getPostcode());
        Lookup nz = (Lookup)((TestCountryBuilder)((TestCountryBuilder)((TestCountryBuilder)this.lookupFactory.newCountry().code("NZ")).name("New Zealand")).isDefault(true)).build();
        Assert.assertEquals((Object)"NZ", (Object)address.getCountryCode());
        Assert.assertEquals((Object)"New Zealand", (Object)address.getCountryName());
        Assert.assertEquals((Object)nz, (Object)address.getCountryLookup());
        Lookup au = (Lookup)((TestCountryBuilder)((TestCountryBuilder)((TestCountryBuilder)this.lookupFactory.newCountry().code("AU")).name("Australia")).isDefault(true)).build();
        Assert.assertEquals((Object)"AU", (Object)address.getCountryCode());
        Assert.assertEquals((Object)"Australia", (Object)address.getCountryName());
        Assert.assertEquals((Object)au, (Object)address.getCountryLookup());
    }
}

