/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.domain.query;

public class Filter<T> {
    private final T value;
    private final Operator operator;

    private Filter(T value, Operator operator) {
        this.value = value;
        this.operator = operator;
    }

    public T getValue() {
        return this.value;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public static <T> Filter<T> equal(T value) {
        return new Filter<T>(value, Operator.EQUAL);
    }

    public static <T> Filter<T> notEqual(T value) {
        return new Filter<T>(value, Operator.NOT_EQUAL);
    }

    public static Filter<String> like(String value) {
        return new Filter<String>(value, Operator.LIKE);
    }

    public static <T extends Comparable<? super T>> Filter<T> lessThan(T value) {
        return new Filter<T>(value, Operator.LESS_THAN);
    }

    public static <T extends Comparable<? super T>> Filter<T> lessThanOrEqualTo(T value) {
        return new Filter<T>(value, Operator.LESS_THAN_EQUAL);
    }

    public static <T extends Comparable<? super T>> Filter<T> greaterThan(T value) {
        return new Filter<T>(value, Operator.GREATER_THAN);
    }

    public static <T extends Comparable<? super T>> Filter<T> greaterThanOrEqualTo(T value) {
        return new Filter<T>(value, Operator.GREATER_THAN_EQUAL);
    }

    public static enum Operator {
        EQUAL,
        NOT_EQUAL,
        LESS_THAN,
        LESS_THAN_EQUAL,
        GREATER_THAN,
        GREATER_THAN_EQUAL,
        LIKE;

    }
}

