/*
 * Version: 1.0
 *
 * The contents of this file are subject to the OpenVPMS License Version
 * 1.0 (the 'License'); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.openvpms.org/license/
 *
 * Software distributed under the License is distributed on an 'AS IS' basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Copyright 2023 (C) OpenVPMS Ltd. All Rights Reserved.
 */

package org.openvpms.domain.till;

import org.openvpms.component.model.entity.Entity;

/**
 * Represents a cash register till.
 *
 * @author Tim Anderson
 */
public interface Till extends Entity {

    /**
     * Returns the till drawer command.
     *
     * @return the command to open the till drawer. May be {@code null}
     */
    DrawerCommand getDrawerCommand();
}
