/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.db.service.impl;

import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.lang3.StringUtils;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.callback.FlywayCallback;
import org.flywaydb.core.internal.dbsupport.DbSupport;
import org.flywaydb.core.internal.dbsupport.DbSupportFactory;
import org.flywaydb.core.internal.dbsupport.Schema;
import org.flywaydb.core.internal.dbsupport.SqlScript;
import org.flywaydb.core.internal.dbsupport.Table;
import org.flywaydb.core.internal.util.PlaceholderReplacer;
import org.flywaydb.core.internal.util.scanner.Resource;
import org.flywaydb.core.internal.util.scanner.classpath.ClassPathResource;
import org.openvpms.component.security.crypto.PasswordEncryptor;
import org.openvpms.component.system.common.crypto.DefaultPasswordEncryptorFactory;
import org.openvpms.db.migration.R__ArchetypeLoader;
import org.openvpms.db.migration.R__PluginLoader;
import org.openvpms.db.service.ArchetypeMigrator;
import org.openvpms.db.service.Checksums;
import org.openvpms.db.service.Credentials;
import org.openvpms.db.service.DatabaseAdminService;
import org.openvpms.db.service.DbVersionInfo;
import org.openvpms.db.service.PluginMigrator;
import org.openvpms.db.service.impl.AbstractDatabaseService;
import org.openvpms.db.service.impl.ChecksumsImpl;
import org.openvpms.db.service.impl.FlywayFactory;
import org.openvpms.db.service.impl.NoOpMigrator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseAdminServiceImpl
extends AbstractDatabaseService
implements DatabaseAdminService {
    private final Credentials adminUser;
    private static final Logger log = LoggerFactory.getLogger(DatabaseAdminService.class);

    public DatabaseAdminServiceImpl(String driver, String url, Credentials adminUser) {
        this(driver, url, adminUser, (Checksums)new ChecksumsImpl());
    }

    public DatabaseAdminServiceImpl(String driver, String url, Credentials adminUser, FlywayCallback listener) {
        this(driver, url, adminUser, new ChecksumsImpl(), listener);
    }

    public DatabaseAdminServiceImpl(String driver, String url, Credentials adminUser, Checksums checksums) {
        this(driver, url, adminUser, checksums, null);
    }

    public DatabaseAdminServiceImpl(String driver, String url, Credentials adminUser, Checksums checksums, FlywayCallback listener) {
        super(driver, url, FlywayFactory.create(driver, url, adminUser, listener), checksums);
        this.adminUser = adminUser;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean exists() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create(Credentials user, Credentials readOnlyUser, String host, boolean createTables) throws SQLException {
        block46: {
            this.checkUsers(user, readOnlyUser);
            try (BasicDataSource rootAdmin = this.createDataSource(this.getRootURL(), this.adminUser);
                 Connection connection = rootAdmin.getConnection();){
                this.checkPermissions(connection);
                boolean found = this.exists(connection);
                if (!found) {
                    DbSupport support = DbSupportFactory.createDbSupport((Connection)connection, (boolean)true);
                    this.createDatabase(support);
                    this.createUsers(user, readOnlyUser, host, support);
                } else if (!createTables) {
                    throw new SQLException("Cannot create " + this.getSchemaName() + " as it already exists");
                }
            }
            if (createTables) {
                R__ArchetypeLoader.setMigrator(new NoOpMigrator());
                R__PluginLoader.setMigrator(new NoOpMigrator());
                try {
                    var6_6 = null;
                    try (Connection connection = this.getDataSource().getConnection();){
                        DbSupport support = DbSupportFactory.createDbSupport((Connection)connection, (boolean)true);
                        Schema schema = support.getOriginalSchema();
                        if (schema.allTables().length == 0) {
                            Resource resource = this.getResource("org/openvpms/db/schema/schema.sql");
                            SqlScript script = new SqlScript(resource.loadAsString("UTF-8"), support);
                            script.execute(support.getJdbcTemplate());
                            MigrationInfo version = this.getBaselineVersion();
                            if (version != null) {
                                this.baseline(version.getVersion(), version.getDescription());
                            }
                            break block46;
                        }
                        throw new SQLException("Cannot create " + this.getSchemaName() + " as there are tables already present");
                    }
                    catch (Throwable throwable) {
                        var6_6 = throwable;
                        throw throwable;
                    }
                }
                finally {
                    this.resetMigrators();
                }
            }
        }
    }

    @Override
    public void createUsers(Credentials user, Credentials readOnlyUser, String host) throws SQLException {
        this.checkUsers(user, readOnlyUser);
        try (Connection connection = this.getDataSource().getConnection();){
            this.checkPermissions(connection);
            DbSupport support = DbSupportFactory.createDbSupport((Connection)connection, (boolean)true);
            this.createUsers(user, readOnlyUser, host, support);
        }
    }

    @Override
    public void update(ArchetypeMigrator archetypeMigrator, PluginMigrator pluginMigrator) throws SQLException {
        this.update(null, archetypeMigrator, pluginMigrator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(String version, ArchetypeMigrator archetypeMigrator, PluginMigrator pluginMigrator) throws SQLException {
        this.checkPreconditions();
        this.baseline();
        if (this.needsChecksumUpdate(this.getInfo())) {
            this.doRepair();
        }
        try {
            R__ArchetypeLoader.setMigrator(archetypeMigrator != null ? this.getArchetypeMigrator(archetypeMigrator) : new NoOpMigrator());
            R__PluginLoader.setMigrator(pluginMigrator != null ? this.getPluginMigrator(pluginMigrator) : new NoOpMigrator());
            Flyway flyway = this.getFlyway();
            if (version != null) {
                flyway.setTargetAsString(version);
            }
            flyway.migrate();
        }
        finally {
            this.resetMigrators();
        }
    }

    public void repair() throws SQLException {
        this.checkPermissions();
        this.doRepair();
    }

    protected String getExistingVersion(Schema<?> schema) {
        Table acts = schema.getTable("acts");
        if (acts != null && acts.hasColumn("status2")) {
            return "1.9";
        }
        return null;
    }

    protected void checkPasswordEncryptionSupport() {
        DefaultPasswordEncryptorFactory factory = new DefaultPasswordEncryptorFactory("cWdFYkhCOFhoK3BsUzNNZjVXZEhaUTo7LllzXUpsRy9g");
        PasswordEncryptor encryptor = factory.create();
        encryptor.encrypt("dummy");
    }

    private void doRepair() {
        try {
            this.installDisabledMigrators();
            this.getFlyway().repair();
        }
        finally {
            this.resetMigrators();
        }
    }

    private void checkUsers(Credentials user, Credentials readOnlyUser) throws SQLException {
        if (this.adminUser.getUser().equals(user.getUser())) {
            throw new SQLException("Admin user cannot be the same as read/write user");
        }
        if (this.adminUser.getUser().equals(readOnlyUser.getUser())) {
            throw new SQLException("Admin user cannot be the same as read-only user");
        }
        if (user.getUser().equals(readOnlyUser.getUser())) {
            throw new SQLException("Read/write and read-only users cannot be the same");
        }
    }

    private void checkPermissions() throws SQLException {
        try (Connection connection = this.getDataSource().getConnection();){
            this.checkPermissions(connection);
        }
    }

    private void checkPermissions(Connection connection) throws SQLException {
        String sql = "SELECT 1 FROM mysql.user WHERE user = ? AND (host = ? OR host = '%') AND select_priv = 'Y' AND update_priv = 'Y' AND delete_priv = 'Y' AND create_priv = 'Y' AND drop_priv = 'Y' AND grant_priv = 'Y' AND index_priv = 'Y' AND alter_priv = 'Y' AND execute_priv = 'Y' AND create_routine_priv = 'Y' AND create_user_priv = 'Y'";
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            boolean failed = false;
            String userHost = this.getUserHost(connection);
            statement.setString(1, StringUtils.substringBefore((String)userHost, (String)"@"));
            statement.setString(2, StringUtils.substringAfter((String)userHost, (String)"@"));
            try (ResultSet set = statement.executeQuery();){
                if (!set.next()) {
                    failed = true;
                }
            }
            catch (SQLException exception) {
                log.error("Failed to query mysql.user: {}", (Object)exception.getMessage(), (Object)exception);
                failed = true;
            }
            if (failed) {
                throw new SQLException("User " + userHost + " doesn't have enough permissions to administer the database");
            }
        }
    }

    private String getUserHost(Connection connection) throws SQLException {
        String result;
        block25: {
            try (Statement statement = connection.createStatement();
                 ResultSet set = statement.executeQuery("SELECT CURRENT_USER() AS user");){
                if (set.next()) {
                    result = set.getString(1);
                    break block25;
                }
                throw new SQLException("Cannot determine connection user");
            }
        }
        return result;
    }

    private void createUsers(Credentials user, Credentials readOnlyUser, String host, DbSupport support) {
        this.createUser(user, host, support);
        this.createReadOnlyUser(support, readOnlyUser, host);
    }

    private void createDatabase(DbSupport support) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("database", this.getSchemaName());
        this.runScript("org/openvpms/db/schema/database.sql", placeholders, support);
    }

    private void createUser(Credentials user, String host, DbSupport support) {
        this.createUser(user, host, "org/openvpms/db/schema/user.sql", support);
    }

    private void createReadOnlyUser(DbSupport support, Credentials user, String host) {
        this.createUser(user, host, "org/openvpms/db/schema/readonlyuser.sql", support);
    }

    private void createUser(Credentials user, String host, String path, DbSupport support) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("database", this.getSchemaName());
        placeholders.put("user", user.getUser());
        placeholders.put("password", user.getPassword());
        placeholders.put("host", host);
        this.runScript(path, placeholders, support);
    }

    private void runScript(String path, Map<String, String> placeholders, DbSupport support) {
        Resource resource = this.getResource(path);
        SqlScript script = new SqlScript(support, resource, new PlaceholderReplacer(placeholders, "${", "}"), StandardCharsets.UTF_8.name(), false);
        script.execute(support.getJdbcTemplate());
    }

    private boolean exists(Connection connection) throws SQLException {
        String schemaName = this.getSchemaName();
        boolean found = false;
        DatabaseMetaData metaData = connection.getMetaData();
        try (ResultSet set = metaData.getCatalogs();){
            while (set.next()) {
                String schema = set.getString("TABLE_CAT");
                if (!schemaName.equalsIgnoreCase(schema)) continue;
                found = true;
                break;
            }
        }
        return found;
    }

    private void checkPreconditions() throws SQLException {
        this.checkFutureVersion();
        try {
            this.checkPasswordEncryptionSupport();
        }
        catch (Exception exception) {
            throw new SQLException("Unable to perform database migration. Strong password encryption is not supported.\nPlease update to a newer version of Java.", exception);
        }
        this.checkPermissions();
    }

    private void checkFutureVersion() throws SQLException {
        DbVersionInfo info = this.getVersionInfo();
        if (info.hasFutureVersion()) {
            throw new SQLException("A future database version has been applied. The database is " + info.getFutureChanges() + " version ahead of the current release.");
        }
    }

    private Resource getResource(String path) {
        return new ClassPathResource(path, this.getClass().getClassLoader());
    }

    private void baseline() throws SQLException {
        block14: {
            MigrationInfo current = this.getInfo().current();
            if (current == null) {
                try (Connection connection = this.getDataSource().getConnection();){
                    DbSupport support = DbSupportFactory.createDbSupport((Connection)connection, (boolean)true);
                    Schema schema = support.getOriginalSchema();
                    if (schema.allTables().length == 0) break block14;
                    String existing = this.getExistingVersion(schema);
                    if (existing != null) {
                        this.baseline(MigrationVersion.fromVersion((String)existing), "Initial schema");
                        break block14;
                    }
                    throw new SQLException("This database needs to be manually migrated to OpenVPMS 1.9");
                }
            }
        }
    }

    private void baseline(MigrationVersion version, String description) {
        Flyway flyway = this.getFlyway();
        flyway.setBaselineVersion(version);
        flyway.setBaselineDescription(description);
        flyway.baseline();
    }
}

