/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.db.service.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.lang3.tuple.Pair;
import org.openvpms.db.service.ArchetypeChecksum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchetypeChecksumImpl
implements ArchetypeChecksum {
    private final String path;
    private static final Logger log = LoggerFactory.getLogger(ArchetypeChecksumImpl.class);
    private static final String PROPERTIES = "META-INF/openvpms-archetypes.properties";

    public ArchetypeChecksumImpl() {
        this(PROPERTIES);
    }

    public ArchetypeChecksumImpl(String path) {
        this.path = path;
    }

    @Override
    public Integer getChecksum() {
        MutableObject system = new MutableObject();
        MutableObject override = new MutableObject();
        try {
            File file = new File(this.path);
            if (file.exists()) {
                URL url = file.toURI().toURL();
                this.getChecksums(url, (MutableObject<Pair<Integer, URL>>)system, (MutableObject<Pair<Integer, URL>>)override);
            } else {
                Enumeration<URL> resources = this.getClass().getClassLoader().getResources(this.path);
                while (resources.hasMoreElements()) {
                    URL url = resources.nextElement();
                    this.getChecksums(url, (MutableObject<Pair<Integer, URL>>)system, (MutableObject<Pair<Integer, URL>>)override);
                }
            }
        }
        catch (IOException exception) {
            throw new IllegalStateException("Failed to read " + this.path, exception);
        }
        if (system.getValue() == null && override.getValue() == null) {
            throw new IllegalStateException("No checksums found");
        }
        Pair result = override.getValue() != null ? (Pair)override.getValue() : (Pair)system.getValue();
        log.info("Using checksum={} from {}", result.getLeft(), result.getRight());
        return (Integer)result.getLeft();
    }

    private void getChecksums(URL url, MutableObject<Pair<Integer, URL>> system, MutableObject<Pair<Integer, URL>> override) {
        try (InputStream stream = url.openStream();){
            Properties properties = new Properties();
            properties.load(stream);
            this.getChecksum("checksum.default", properties, url, system);
            this.getChecksum("checksum.override", properties, url, override);
        }
        catch (IOException exception) {
            throw new IllegalStateException("Failed to read " + url, exception);
        }
    }

    private void getChecksum(String name, Properties properties, URL url, MutableObject<Pair<Integer, URL>> checksum) {
        Pair<Integer, URL> found = this.getChecksum(name, properties, url, (Pair<Integer, URL>)((Pair)checksum.getValue()));
        if (found != null) {
            checksum.setValue(found);
        }
    }

    private Pair<Integer, URL> getChecksum(String name, Properties properties, URL url, Pair<Integer, URL> existing) {
        Pair<Integer, URL> result = null;
        Integer value = this.getChecksum(name, properties);
        if (value != null) {
            if (existing == null) {
                result = new Pair<Integer, URL>((Object)value, (Object)url);
            } else if (Objects.equals(existing.getLeft(), value)) {
                result = existing;
            } else {
                throw new IllegalStateException("Duplicate " + name + " property defined in " + existing.getRight() + " and " + url);
            }
        }
        return result;
    }

    private Integer getChecksum(String name, Properties properties) {
        String value = properties.getProperty(name);
        return value != null ? Integer.valueOf(Integer.parseUnsignedInt(value, 16)) : null;
    }
}

