#
# OVPMS-3067 Add price create, delivery item delete authorities to Stock Manager role
#

#
# Add authorities.
#
DROP TABLE IF EXISTS new_authorities;
CREATE TEMPORARY TABLE new_authorities
(
    name        VARCHAR(255) PRIMARY KEY,
    description VARCHAR(255),
    method      VARCHAR(255),
    archetype   VARCHAR(255)
);

INSERT INTO new_authorities (name, description, method, archetype)
VALUES ('Supplier Delivery Item Remove', 'Authority to Remove Supplier Delivery Item', 'remove',
        'act.supplierDeliveryItem');

INSERT INTO granted_authorities (version, linkId, arch_short_name, arch_version, name, description, active,
                                 service_name, method, archetype)
SELECT 0,
       UUID(),
       'security.archetypeAuthority',
       '1.0',
       a.name,
       a.description,
       1,
       'archetypeService',
       a.method,
       a.archetype
FROM new_authorities a
WHERE NOT EXISTS(SELECT *
                 FROM granted_authorities g
                 WHERE g.method = a.method
                   AND g.archetype = a.archetype);

#
# Add authorities to Stock Manager Role.
#
INSERT INTO roles_authorities (security_role_id, authority_id)
SELECT r.security_role_id,
       g.granted_authority_id
FROM security_roles r
         JOIN granted_authorities g
WHERE r.name = 'Stock Manager'
  AND ((g.archetype = 'productPrice.*' AND g.method = 'create')
    OR (g.archetype = 'act.supplierDeliveryItem' AND g.method = 'remove'))
  AND NOT EXISTS(SELECT *
                 FROM roles_authorities x
                 WHERE x.security_role_id = r.security_role_id
                   AND x.authority_id = g.granted_authority_id);


DROP TABLE new_authorities;