/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.db.service.impl;

import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.callback.FlywayCallback;
import org.openvpms.db.service.Credentials;
import org.openvpms.db.service.impl.DataSourceFactory;

class FlywayFactory {
    FlywayFactory() {
    }

    public static Flyway create(String driver, String url, Credentials user, FlywayCallback listener) {
        BasicDataSource dataSource = DataSourceFactory.createDataSource(driver, url, user);
        return FlywayFactory.create((DataSource)dataSource, listener);
    }

    public static Flyway create(DataSource dataSource) {
        return FlywayFactory.create(dataSource, null);
    }

    public static Flyway create(DataSource dataSource, FlywayCallback listener) {
        Flyway flyway = new Flyway();
        flyway.setLocations(new String[]{"org/openvpms/db/migration"});
        flyway.setDataSource(dataSource);
        if (listener != null) {
            flyway.setCallbacks(new FlywayCallback[]{listener});
        }
        return flyway;
    }
}

