/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.db.service.impl;

class DbURLParser {
    private final String rootUrl;
    private final String schemaName;

    public DbURLParser(String url) {
        int lastSlash;
        if (!url.startsWith("jdbc:")) {
            throw new IllegalArgumentException("Invalid JDBC URL: " + url);
        }
        int questionIndex = url.indexOf(63);
        String parameters = null;
        if (questionIndex != -1) {
            parameters = url.substring(questionIndex);
            url = url.substring(0, questionIndex);
        }
        if ((lastSlash = url.lastIndexOf(47)) == -1) {
            throw new IllegalArgumentException("Invalid JDBC URL: " + url);
        }
        this.schemaName = url.substring(lastSlash + 1);
        url = url.substring(0, lastSlash);
        this.rootUrl = parameters != null ? url + parameters : url;
    }

    public String getRootUrl() {
        return this.rootUrl;
    }

    public String getSchemaName() {
        return this.schemaName;
    }
}

