/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.db.util;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ArchetypeDescriptorRemover {
    public Map<String, Long> getArchetypes(Connection connection) throws SQLException {
        String sql = "SELECT archetype_desc_id, name FROM archetype_descriptors";
        HashMap<String, Long> descriptors = new HashMap<String, Long>();
        try (PreparedStatement statement = connection.prepareStatement(sql);
             ResultSet set = statement.executeQuery();){
            while (set.next()) {
                long id = set.getLong(1);
                String name = set.getString(2);
                int index = StringUtils.ordinalIndexOf((CharSequence)name, (CharSequence)".", (int)2);
                String archetype = index != -1 ? name.substring(0, index) : name;
                descriptors.put(archetype, id);
            }
        }
        return descriptors;
    }

    public void remove(String archetype, Connection connection) throws SQLException {
        Map<String, Long> archetypes = this.getArchetypes(connection);
        Long id = archetypes.get(archetype);
        if (id != null) {
            this.remove(id, connection);
        }
    }

    public void remove(long id, Connection connection) throws SQLException {
        String nodeSQL = "SELECT node_desc_id FROM node_descriptors WHERE archetype_desc_id = ?";
        try (PreparedStatement statement = connection.prepareStatement(nodeSQL);){
            statement.setLong(1, id);
            this.removeNodeDescriptors(statement, connection);
        }
        String archetypeSQL = "DELETE a FROM archetype_descriptors a WHERE a.archetype_desc_id = ?";
        try (PreparedStatement statement = connection.prepareStatement(archetypeSQL);){
            statement.setLong(1, id);
            statement.executeUpdate();
        }
    }

    private void removeNodeDescriptors(PreparedStatement statement, Connection connection) throws SQLException {
        try (ResultSet set = statement.executeQuery();){
            while (set.next()) {
                this.removeNodeDescriptor(set.getLong(1), connection);
            }
        }
    }

    private void removeNodeDescriptor(long id, Connection connection) throws SQLException {
        String childSQL = "SELECT node_desc_id FROM node_descriptors WHERE parent_id = ?";
        try (PreparedStatement statement = connection.prepareStatement(childSQL);){
            statement.setLong(1, id);
            this.removeNodeDescriptors(statement, connection);
        }
        this.removeAssertionDescriptors(id, connection);
        String deleteSQL = "DELETE n FROM node_descriptors n WHERE node_desc_id = ?";
        try (PreparedStatement statement = connection.prepareStatement(deleteSQL);){
            statement.setLong(1, id);
            statement.executeUpdate();
        }
    }

    private void removeAssertionDescriptors(long id, Connection connection) throws SQLException {
        String sql = "DELETE ad FROM assertion_descriptors ad WHERE node_desc_id = ?";
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setLong(1, id);
            statement.executeUpdate();
        }
    }
}

