/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.db.service;

import java.sql.SQLException;
import org.openvpms.db.service.DatabaseService;
import org.openvpms.db.service.DbVersion;
import org.openvpms.db.service.DbVersionInfo;

public class DatabaseVersionChecker {
    public DatabaseVersionChecker() {
    }

    public DatabaseVersionChecker(DatabaseService service) throws SQLException {
        this.check(service);
    }

    public void check(DatabaseService service) throws SQLException {
        DbVersionInfo info = service.getVersionInfo();
        if (info.needsUpdate()) {
            int changes = info.getChanges();
            DbVersion version = info.getMigrationVersion();
            if (version.getVersion() != null) {
                throw new SQLException("The database needs to be updated to version " + version + ". " + changes + " changes need to be applied.");
            }
            throw new SQLException("The database needs to be updated. " + changes + " changes need to be applied.");
        }
        if (info.hasFutureVersion()) {
            throw new SQLException("A future database version has been applied. The database is " + info.getFutureChanges() + " versions ahead of the current release.");
        }
    }
}

