/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.db.migration.v2_1;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.flywaydb.core.api.migration.jdbc.BaseJdbcMigration;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;

public class V2_1_0_12__OVPMS_428
extends BaseJdbcMigration {
    public void migrate(Connection connection) throws Exception {
        BCryptPasswordEncoder encoder = new BCryptPasswordEncoder();
        try (PreparedStatement select = connection.prepareStatement("SELECT user_id, password FROM users");
             PreparedStatement update = connection.prepareStatement("UPDATE users SET password=? WHERE user_id=?");
             ResultSet resultSet = select.executeQuery();){
            while (resultSet.next()) {
                long id = resultSet.getLong(1);
                String password = resultSet.getString(2);
                if (password == null || password.length() <= 0) continue;
                String encoded = encoder.encode((CharSequence)password);
                update.setString(1, encoded);
                update.setLong(2, id);
                update.executeUpdate();
            }
        }
    }
}

