/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.db.migration.v2_1;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.flywaydb.core.api.migration.jdbc.BaseJdbcMigration;
import org.openvpms.component.security.crypto.PasswordEncryptor;
import org.openvpms.component.system.common.crypto.DefaultPasswordEncryptorFactory;

public class V2_1_0_10__OVPMS_2233
extends BaseJdbcMigration {
    public void migrate(Connection connection) throws Exception {
        String key = System.getProperty("openvpms.key");
        if (key == null) {
            throw new SQLException("openvpms.key has not been defined");
        }
        DefaultPasswordEncryptorFactory factory = new DefaultPasswordEncryptorFactory(key);
        PasswordEncryptor encryptor = factory.create();
        this.encrypt("entities", "entity_details", "entity_id", "entity.mailServer", "password", connection, encryptor);
        this.encrypt("entity_relationships", "entity_relationship_details", "entity_relationship_id", "entityRelationship.supplierStockLocationESCI", "password", connection, encryptor);
        this.encrypt("entities", "entity_details", "entity_id", "party.organisationLocation", "smartFlowSheetKey", connection, encryptor);
        this.encrypt("entities", "entity_details", "entity_id", "entity.pluginDeputy", "accessToken", connection, encryptor);
        this.encrypt("entities", "entity_details", "entity_id", "entity.insuranceServicePetSure", "password", connection, encryptor);
    }

    private void encrypt(String table, String details, String idColumn, String archetype, String name, Connection connection, PasswordEncryptor encryptor) throws SQLException {
        HashMap<Long, String> passwords = new HashMap<Long, String>();
        String tableId = table + "." + idColumn;
        String detailsId = details + "." + idColumn;
        String select = "select " + tableId + ", " + details + ".value from " + table + " join " + details + " on " + tableId + " = " + detailsId + " where " + table + ".arch_short_name = ? and " + details + ".name = ?";
        try (PreparedStatement statement = connection.prepareStatement(select);){
            statement.setString(1, archetype);
            statement.setString(2, name);
            ResultSet resultSet = statement.executeQuery();
            Object object = null;
            try {
                while (resultSet.next()) {
                    long l = resultSet.getLong(1);
                    String password = resultSet.getString(2);
                    if (password == null || password.length() <= 0) continue;
                    passwords.put(l, password);
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (resultSet != null) {
                    if (object != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        resultSet.close();
                    }
                }
            }
        }
        if (!passwords.isEmpty()) {
            String update = "update " + table + " join " + details + " on " + tableId + " = " + detailsId + "  set " + details + ".value = ? where " + tableId + " = ? and " + details + ".name = ? and " + details + ".value = ?";
            try (PreparedStatement statement = connection.prepareStatement(update);){
                for (Map.Entry entry : passwords.entrySet()) {
                    long id = (Long)entry.getKey();
                    String plain = (String)entry.getValue();
                    String encrypted = encryptor.encrypt(plain);
                    statement.setString(1, encrypted);
                    statement.setLong(2, id);
                    statement.setString(3, name);
                    statement.setString(4, plain);
                    statement.executeUpdate();
                }
            }
        }
    }
}

