#
# OVPMS-2809 Payment processor API
#

#
# Add authorities.
#
DROP TABLE IF EXISTS new_authorities;
CREATE TEMPORARY TABLE new_authorities
(
    name        VARCHAR(255) PRIMARY KEY,
    description VARCHAR(255),
    method      VARCHAR(255),
    archetype   VARCHAR(255)
);

INSERT INTO new_authorities (name, description, method, archetype)
VALUES ('Payment Processor Act Create', 'Authority to Create Payment Processor Act', 'create', 'act.paymentProcessor*'),
       ('Payment Processor Act Save', 'Authority to Save Payment Processor Act', 'save', 'act.paymentProcessor*'),
       ('Payment Processor Act Remove', 'Authority to Remove Payment Processor Act', 'remove', 'act.paymentProcessor*');

INSERT INTO granted_authorities (version, linkId, arch_short_name, arch_version, name, description, active,
                                 service_name, method, archetype)
SELECT 0,
       UUID(),
       'security.archetypeAuthority',
       '1.0',
       a.name,
       a.description,
       1,
       'archetypeService',
       a.method,
       a.archetype
FROM new_authorities a
WHERE NOT EXISTS(
        SELECT *
        FROM granted_authorities g
        WHERE g.method = a.method
          AND g.archetype = a.archetype);

#
# Add authorities to Base Role. Note that the remove role isn't added.
#
INSERT INTO roles_authorities (security_role_id, authority_id)
SELECT r.security_role_id,
       g.granted_authority_id
FROM security_roles r
         JOIN granted_authorities g
WHERE r.name = 'Base Role'
  AND g.archetype IN ('act.paymentProcessor*')
  AND g.method IN ('create', 'save')
  AND NOT EXISTS(SELECT *
                 FROM roles_authorities x
                 WHERE x.security_role_id = r.security_role_id
                   AND x.authority_id = g.granted_authority_id);

DROP TABLE new_authorities;

#
# Add lookup.documentTemplateType archetypes for reports.
#
DROP TABLE IF EXISTS tmp_lookups;

CREATE TABLE tmp_lookups
(
    code varchar(100) PRIMARY KEY,
    name varchar(100) NOT NULL
);

INSERT INTO tmp_lookups (code, name)
VALUES ('WORK_IN_PROGRESS_PAYMENTS', 'Work in Progress Payments'),
       ('PAYMENTS', 'PAYMENTS'),
        ('act.paymentProcessorPayment', 'Payment Processor Payment'),
        ('act.paymentProcessorRefund', 'Payment Processor Refund');

INSERT INTO lookups (version, linkId, arch_short_name, active, arch_version,
                     code, name, description, default_lookup)
SELECT 0,
       UUID(),
       'lookup.documentTemplateType',
       TRUE,
       '1.0',
       l.code,
       l.name,
       NULL,
       FALSE
FROM tmp_lookups l
WHERE NOT EXISTS(SELECT * FROM lookups t WHERE t.code = l.code);

DROP TABLE tmp_lookups;