/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.db.service.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.MigrationInfoService;
import org.flywaydb.core.internal.info.MigrationInfoServiceImpl;
import org.openvpms.db.migration.R__ArchetypeLoader;
import org.openvpms.db.migration.R__PluginLoader;
import org.openvpms.db.service.ArchetypeMigrator;
import org.openvpms.db.service.Checksums;
import org.openvpms.db.service.Credentials;
import org.openvpms.db.service.DatabaseService;
import org.openvpms.db.service.DbVersion;
import org.openvpms.db.service.DbVersionInfo;
import org.openvpms.db.service.Migrator;
import org.openvpms.db.service.PluginMigrator;
import org.openvpms.db.service.impl.DataSourceFactory;
import org.openvpms.db.service.impl.DbURLParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDatabaseService
implements DatabaseService {
    private final String driver;
    private final String rootURL;
    private final String schemaName;
    private final Flyway flyway;
    private final Map<String, Integer> changedChecksums;
    private final Checksums checksums;
    private static final Logger log = LoggerFactory.getLogger(AbstractDatabaseService.class);

    public AbstractDatabaseService(String driver, String url, Flyway flyway, Checksums checksums) {
        this.driver = driver;
        DbURLParser parser = new DbURLParser(url);
        this.rootURL = parser.getRootUrl();
        this.schemaName = parser.getSchemaName();
        this.flyway = flyway;
        this.checksums = checksums;
        this.changedChecksums = this.getChangedChecksums();
        log.info("Using database {}, URL={}", (Object)this.schemaName, (Object)url);
    }

    @Override
    public String getSchemaName() {
        return this.schemaName;
    }

    @Override
    public String getVersion() {
        String result = null;
        MigrationInfo current = this.getInfo().current();
        if (current != null) {
            result = current.getVersion().toString();
        }
        return result;
    }

    @Override
    public DbVersionInfo getVersionInfo() {
        MigrationInfoServiceImpl service = (MigrationInfoServiceImpl)this.getInfo();
        DbVersion version = this.toVersionInfo(service.current());
        DbVersion migrationVersion = this.getMigrationVersion((MigrationInfoService)service);
        int changes = this.getChangesToApply(service);
        MigrationInfo[] future = service.future();
        int futureChanges = future.length;
        return new DbVersionInfo(version, migrationVersion, changes, futureChanges);
    }

    @Override
    public long getSize() throws SQLException {
        long result = -1L;
        try (Connection connection = this.getDataSource().getConnection();
             PreparedStatement statement = connection.prepareStatement("SELECT SUM(data_length + index_length) AS size FROM information_schema.tables WHERE TABLE_SCHEMA = ?");){
            statement.setString(1, this.getSchemaName());
            ResultSet set = statement.executeQuery();
            if (set.next()) {
                result = set.getLong(1);
            }
        }
        return result;
    }

    public MigrationInfoService getInfo() {
        try {
            this.installDisabledMigrators();
            MigrationInfoService migrationInfoService = this.flyway.info();
            return migrationInfoService;
        }
        finally {
            this.resetMigrators();
        }
    }

    protected Flyway getFlyway() {
        return this.flyway;
    }

    protected DataSource getDataSource() {
        return this.flyway.getDataSource();
    }

    protected String getRootURL() {
        return this.rootURL;
    }

    protected BasicDataSource createDataSource(String url, Credentials user) {
        return DataSourceFactory.createDataSource(this.driver, url, user);
    }

    protected MigrationInfo getBaselineVersion() {
        MigrationInfo result = null;
        MigrationInfo[] info = this.getInfo().pending();
        for (int index = info.length - 1; index >= 0; --index) {
            if (info[index].getVersion() == null) continue;
            result = info[index];
            break;
        }
        return result;
    }

    protected void installDisabledMigrators() {
        R__ArchetypeLoader.setMigrator(this.disabledMigrator(this.checksums::getArchetypeChecksum));
        R__PluginLoader.setMigrator(this.disabledMigrator(this.checksums::getPluginChecksum));
    }

    protected void resetMigrators() {
        R__ArchetypeLoader.setMigrator(null);
        R__PluginLoader.setMigrator(null);
    }

    protected Migrator getArchetypeMigrator(final ArchetypeMigrator migrator) {
        return new Migrator(){

            @Override
            public Integer getChecksum() {
                return AbstractDatabaseService.this.checksums.getArchetypeChecksum();
            }

            @Override
            public void migrate() {
                migrator.migrate();
            }
        };
    }

    protected Migrator getPluginMigrator(final PluginMigrator migrator) {
        return new Migrator(){

            @Override
            public Integer getChecksum() {
                return AbstractDatabaseService.this.checksums.getPluginChecksum();
            }

            @Override
            public void migrate() {
                migrator.migrate();
            }
        };
    }

    protected boolean needsChecksumUpdate(MigrationInfoService migrationInfo) {
        for (MigrationInfo info : migrationInfo.all()) {
            if (!info.getState().isFailed()) continue;
            return false;
        }
        for (MigrationInfo info : migrationInfo.applied()) {
            String version;
            Integer newCheckSum;
            if (info.getVersion() == null || (newCheckSum = this.changedChecksums.get(version = info.getVersion().getVersion())) == null || newCheckSum.equals(info.getChecksum())) continue;
            return true;
        }
        return false;
    }

    protected static DataSource createDataSource(String driver, String url, Credentials user) {
        return AbstractDatabaseService.createDataSource(driver, url, user.getUser(), user.getPassword());
    }

    protected static DataSource createDataSource(String driver, String url, String user, String password) {
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.setDriverClassName(driver);
        dataSource.setUrl(url);
        dataSource.setUsername(user);
        dataSource.setPassword(password);
        return dataSource;
    }

    private DbVersion getMigrationVersion(MigrationInfoService service) {
        MigrationInfo[] info = service.pending();
        return this.toVersionInfo(info.length > 0 ? info[info.length - 1] : null);
    }

    private int getChangesToApply(MigrationInfoServiceImpl info) {
        int result = info.pending().length + info.failed().length;
        if (this.needsChecksumUpdate((MigrationInfoService)info)) {
            ++result;
        }
        return result;
    }

    private DbVersion toVersionInfo(MigrationInfo info) {
        DbVersion result = null;
        if (info != null) {
            String version = info.getVersion() != null ? info.getVersion().toString() : null;
            result = new DbVersion(version, info.getDescription());
        }
        return result;
    }

    private Map<String, Integer> getChangedChecksums() {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        result.put("2.1.0.3", -427272242);
        result.put("2.1.0.5", 229982045);
        result.put("2.1.0.9", 1610869084);
        result.put("2.1.0.11", 1116763144);
        result.put("2.1.0.13", 1611424731);
        return result;
    }

    private Migrator disabledMigrator(final Supplier<Integer> checksum) {
        return new Migrator(){

            @Override
            public Integer getChecksum() {
                return (Integer)checksum.get();
            }

            @Override
            public void migrate() {
                throw new IllegalStateException("Cannot perform migration");
            }
        };
    }
}

