/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.maven.db;

import java.sql.SQLException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.openvpms.db.service.Checksums;
import org.openvpms.db.service.Credentials;
import org.openvpms.db.service.impl.ArchetypeChecksumImpl;
import org.openvpms.db.service.impl.ChecksumsImpl;
import org.openvpms.db.service.impl.DatabaseAdminServiceImpl;
import org.openvpms.maven.archetype.AbstractArchetypeLoadMojo;

public class AbstractDatabaseUpdateMojo
extends AbstractArchetypeLoadMojo {
    @Parameter(required=true)
    private String adminUsername;
    @Parameter(required=true)
    private String adminPassword;
    @Parameter(required=true)
    private String checksum;

    protected void doExecute() throws MojoExecutionException {
        ChecksumsImpl checksums = new ChecksumsImpl(){

            public Integer getArchetypeChecksum() {
                return new ArchetypeChecksumImpl(AbstractDatabaseUpdateMojo.this.checksum).getChecksum();
            }
        };
        Credentials adminUser = new Credentials(this.adminUsername, this.adminPassword);
        DatabaseAdminServiceImpl tool = new DatabaseAdminServiceImpl(this.getDriver(), this.getUrl(), adminUser, (Checksums)checksums, null);
        try {
            tool.update(() -> {
                try {
                    this.loadArchetypes();
                }
                catch (MojoExecutionException exception) {
                    throw new IllegalStateException(exception.getMessage(), exception);
                }
            }, () -> {});
        }
        catch (SQLException exception) {
            throw new MojoExecutionException("Failed to update database " + tool.getSchemaName(), (Exception)exception);
        }
    }
}

