/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.maven.db;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.flywaydb.core.internal.dbsupport.DbSupport;
import org.flywaydb.core.internal.dbsupport.DbSupportFactory;
import org.flywaydb.core.internal.dbsupport.Schema;
import org.openvpms.db.service.Checksums;
import org.openvpms.db.service.Credentials;
import org.openvpms.db.service.impl.DatabaseAdminServiceImpl;
import org.openvpms.maven.archetype.AbstractHibernateMojo;

@Mojo(name="create", requiresDependencyResolution=ResolutionScope.TEST)
public class DatabaseCreateMojo
extends AbstractHibernateMojo {
    @Parameter(required=true)
    private String adminUsername;
    @Parameter(required=true)
    private String adminPassword;
    @Parameter(required=true)
    private String reportingUsername;
    @Parameter(required=true)
    private String reportingPassword;
    @Parameter(required=true)
    private String checksum;
    @Parameter
    private boolean skip;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.skip) {
            super.execute();
        } else {
            this.getLog().info((CharSequence)"Plugin is skipped");
        }
    }

    protected void doExecute() throws MojoExecutionException {
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.setDriverClassName(this.getDriver());
        dataSource.setUsername(this.adminUsername);
        dataSource.setPassword(this.adminPassword);
        dataSource.setUrl(this.getUrl());
        Checksums checksums = new Checksums(){

            public Integer getArchetypeChecksum() {
                return null;
            }

            public Integer getPluginChecksum() {
                return null;
            }
        };
        Credentials adminUser = new Credentials(this.adminUsername, this.adminPassword);
        Credentials user = new Credentials(this.getUsername(), this.getPassword());
        Credentials reportingUser = new Credentials(this.reportingUsername, this.reportingPassword);
        DatabaseAdminServiceImpl tool = new DatabaseAdminServiceImpl(this.getDriver(), this.getUrl(), adminUser, checksums);
        try (Connection connection = dataSource.getConnection();){
            DbSupport dbSupport = DbSupportFactory.createDbSupport((Connection)connection, (boolean)true);
            Schema schema = dbSupport.getSchema(tool.getSchemaName());
            if (schema.exists()) {
                this.getLog().info((CharSequence)("Dropping database " + tool.getSchemaName()));
                schema.drop();
            }
        }
        catch (SQLException exception) {
            throw new MojoExecutionException("Failed to drop database " + tool.getSchemaName(), (Exception)exception);
        }
        try {
            this.getLog().info((CharSequence)("Creating database " + tool.getSchemaName()));
            tool.create(user, reportingUser, "localhost", true);
        }
        catch (SQLException exception) {
            throw new MojoExecutionException("Failed to create database " + tool.getSchemaName(), (Exception)exception);
        }
    }
}

