/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.maven.data;

import java.io.File;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.maven.archetype.AbstractHibernateMojo;
import org.openvpms.tools.data.loader.StaxArchetypeDataLoader;
import org.springframework.context.ApplicationContext;

public abstract class AbstractDataMojo
extends AbstractHibernateMojo {
    @Parameter(required=true)
    private File dir;
    @Parameter
    private boolean skip;
    @Parameter
    private boolean verbose;

    public File getDir() {
        return this.dir;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.skip) {
            super.execute();
        } else {
            this.getLog().info((CharSequence)"Plugin is skipped");
        }
    }

    protected void doExecute() throws MojoExecutionException {
        if (this.dir == null || !this.dir.exists()) {
            throw new MojoExecutionException("Directory not found: " + this.dir);
        }
        if (!this.dir.isDirectory()) {
            throw new MojoExecutionException("Not a directory: " + this.dir);
        }
        try {
            ApplicationContext context = this.getContext();
            IArchetypeService service = (IArchetypeService)context.getBean("archetypeService");
            StaxArchetypeDataLoader loader = new StaxArchetypeDataLoader(service);
            this.doExecute(loader);
        }
        catch (Exception exception) {
            throw new MojoExecutionException("Failed to load data", exception);
        }
    }

    protected abstract void doExecute(StaxArchetypeDataLoader var1) throws IOException, XMLStreamException;

    protected String[] getContextPaths() {
        return new String[]{"mavenPluginApplicationContext.xml", "dataloadContext.xml"};
    }
}

