/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.booking.impl;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.NotFoundException;
import org.openvpms.booking.api.UserService;
import org.openvpms.booking.domain.Location;
import org.openvpms.booking.domain.ScheduleRange;
import org.openvpms.booking.domain.UserFreeBusy;
import org.openvpms.booking.impl.BookingCalendar;
import org.openvpms.booking.impl.BookingLocations;
import org.openvpms.booking.impl.BookingUsers;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.springframework.stereotype.Component;

@Component
public class UserServiceImpl
implements UserService {
    private final BookingCalendar calendar;
    private final BookingLocations locations;
    private final BookingUsers users;

    public UserServiceImpl(BookingCalendar calendar, BookingLocations locations, BookingUsers users) {
        this.calendar = calendar;
        this.locations = locations;
        this.users = users;
    }

    @Override
    public org.openvpms.booking.domain.User getUser(long userId) {
        User user = this.getUserEntity(userId);
        return new org.openvpms.booking.domain.User(user.getId(), user.getName());
    }

    @Override
    public List<Location> getLocations(long userId) {
        ArrayList<Location> result = new ArrayList<Location>();
        User user = this.getUserEntity(userId);
        String timeZone = this.locations.getTimeZone().getID();
        for (Party location : this.users.getLocations(user)) {
            result.add(new Location(location.getId(), location.getName(), timeZone));
        }
        return result;
    }

    @Override
    public Location getLocation(long userId, long locationId) {
        User user = this.getUserEntity(userId);
        Party location = this.getLocation(user, locationId);
        String timeZone = this.locations.getTimeZone().getID();
        return new Location(location.getId(), location.getName(), timeZone);
    }

    @Override
    public List<ScheduleRange> getFree(long userId, long locationId, String from, String to) {
        User user = this.getUserEntity(userId);
        Party location = this.getLocation(user, locationId);
        return this.calendar.getFree(user, location, from, to);
    }

    @Override
    public List<ScheduleRange> getBusy(long userId, long locationId, String from, String to) {
        User user = this.getUserEntity(userId);
        Party location = this.getLocation(user, locationId);
        return this.calendar.getBusy(user, location, from, to);
    }

    @Override
    public UserFreeBusy getFreeBusy(long userId, long locationId, String from, String to) {
        User user = this.getUserEntity(userId);
        Party location = this.getLocation(user, locationId);
        return this.calendar.getFreeBusy(user, location, from, to);
    }

    private User getUserEntity(long id) {
        User user = this.users.getUser(id);
        if (user == null) {
            throw new NotFoundException("User not found");
        }
        return user;
    }

    private Party getLocation(User user, long locationId) {
        Party location = this.users.getLocation(user, locationId);
        if (location == null) {
            throw new NotFoundException("Location not found");
        }
        return location;
    }
}

