/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.booking.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.ws.rs.NotFoundException;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.rules.workflow.AppointmentRules;
import org.openvpms.archetype.rules.workflow.AppointmentService;
import org.openvpms.booking.api.ScheduleService;
import org.openvpms.booking.domain.AppointmentType;
import org.openvpms.booking.domain.FreeBusy;
import org.openvpms.booking.domain.Range;
import org.openvpms.booking.domain.Schedule;
import org.openvpms.booking.impl.AppointmentSchedule;
import org.openvpms.booking.impl.DateHelper;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.util.PropertySet;
import org.springframework.stereotype.Component;

@Component
public class ScheduleServiceImpl
implements ScheduleService {
    private final IArchetypeService service;
    private final AppointmentService appointments;
    private final AppointmentRules rules;

    public ScheduleServiceImpl(IArchetypeService service, AppointmentService appointments, AppointmentRules rules) {
        this.service = service;
        this.appointments = appointments;
        this.rules = rules;
    }

    @Override
    public Schedule getSchedule(long scheduleId) {
        org.openvpms.component.business.domain.im.common.Entity schedule = this.getScheduleEntity(scheduleId);
        int slotSize = this.rules.getSlotSize((Entity)schedule);
        return new Schedule(schedule.getId(), schedule.getName(), slotSize);
    }

    @Override
    public List<Range> getFree(long scheduleId, String from, String to, boolean slots) {
        ArrayList<Range> free = new ArrayList<Range>();
        this.query(scheduleId, from, to, free, null, slots);
        return free;
    }

    @Override
    public List<Range> getBusy(long scheduleId, String from, String to, boolean slots) {
        ArrayList<Range> busy = new ArrayList<Range>();
        this.query(scheduleId, from, to, null, busy, slots);
        return busy;
    }

    @Override
    public FreeBusy getFreeBusy(long scheduleId, String from, String to, boolean slots) {
        ArrayList<Range> free = new ArrayList<Range>();
        ArrayList<Range> busy = new ArrayList<Range>();
        this.query(scheduleId, from, to, free, busy, slots);
        return new FreeBusy(free, busy);
    }

    @Override
    public List<AppointmentType> getAppointmentTypes(long scheduleId) {
        AppointmentSchedule schedule = this.getAppointmentSchedule(scheduleId);
        return schedule.getAppointmentTypes();
    }

    protected void query(long scheduleId, String from, String to, List<Range> free, List<Range> busy, boolean slots) {
        Date fromTime = DateHelper.getDate("from", from);
        Date toTime = DateHelper.getDate("to", to);
        AppointmentSchedule schedule = this.getAppointmentSchedule(scheduleId);
        int slotSize = schedule.getSlotSize();
        Date date = fromTime;
        while (date.compareTo(toTime) <= 0) {
            Date startTime = schedule.getStartTime(date);
            Date endTime = schedule.getEndTime(date);
            if (startTime != null && endTime != null) {
                Date min = DateRules.max((Date)startTime, (Date)fromTime);
                Date max = DateRules.min((Date)endTime, (Date)toTime);
                this.addFreeBusy(date, schedule, min, max, free, busy);
            }
            date = DateRules.getDate((Date)date, (int)1, (DateUnits)DateUnits.DAYS);
        }
        if (slots && slotSize > 0) {
            if (free != null) {
                this.split(free, slotSize);
            }
            if (busy != null) {
                this.split(busy, slotSize);
            }
        }
    }

    private AppointmentSchedule getAppointmentSchedule(long scheduleId) {
        org.openvpms.component.business.domain.im.common.Entity entity = this.getScheduleEntity(scheduleId);
        return new AppointmentSchedule((Entity)entity, (ArchetypeService)this.service, this.rules);
    }

    private void addFreeBusy(Date date, AppointmentSchedule schedule, Date min, Date max, List<Range> free, List<Range> busy) {
        List events = this.appointments.getEvents(schedule.getSchedule(), date);
        Date freeStart = min;
        Date freeEnd = max;
        Date busyStart = null;
        Date busyEnd = null;
        for (PropertySet event : events) {
            if ("CANCELLED".equals(event.getString("act.status"))) continue;
            Date actStart = event.getDate("act.startTime");
            Date actEnd = event.getDate("act.endTime");
            if (free != null && DateRules.compareTo((Date)actStart, (Date)freeStart) > 0) {
                ScheduleServiceImpl.addRange(free, freeStart, actStart, min, max);
            }
            if (busy != null) {
                if (busyStart == null || DateRules.compareTo((Date)actStart, busyEnd) > 0) {
                    if (busyStart != null) {
                        ScheduleServiceImpl.addRange(busy, busyStart, busyEnd, min, max);
                    }
                    busyStart = actStart;
                    busyEnd = actEnd;
                } else if (DateRules.compareTo((Date)actEnd, (Date)busyEnd) > 0) {
                    busyEnd = actEnd;
                }
            }
            if (free == null) continue;
            if (DateRules.compareTo((Date)actEnd, (Date)freeStart) > 0) {
                freeStart = actEnd;
            }
            if (freeEnd == null || DateRules.compareTo((Date)actEnd, (Date)freeEnd) <= 0) continue;
            freeEnd = null;
        }
        if (free != null && freeEnd != null) {
            ScheduleServiceImpl.addRange(free, freeStart, freeEnd, min, max);
        }
        if (busy != null && busyStart != null) {
            ScheduleServiceImpl.addRange(busy, busyStart, busyEnd, min, max);
        }
    }

    private static void addRange(List<Range> ranges, Date from, Date to, Date min, Date max) {
        from = DateHelper.convert(from);
        if (DateRules.compareTo((Date)(to = DateHelper.convert(to)), (Date)min) >= 0) {
            if (DateRules.compareTo((Date)from, (Date)min) <= 0) {
                from = min;
            }
            if (DateRules.compareTo((Date)from, (Date)max) < 0) {
                if (DateRules.compareTo((Date)to, (Date)max) > 0) {
                    to = max;
                }
                ranges.add(new Range(from, to));
            }
        }
    }

    private void split(List<Range> ranges, int slotSize) {
        if (!ranges.isEmpty()) {
            ArrayList<Range> split = new ArrayList<Range>();
            for (Range range : ranges) {
                Date to;
                Date start = this.rules.getSlotTime(range.getStart(), slotSize, true);
                Date end = this.rules.getSlotTime(range.getEnd(), slotSize, false);
                Date from = start;
                while (from.compareTo(end) < 0 && (to = DateRules.getDate((Date)from, (int)slotSize, (DateUnits)DateUnits.MINUTES)).compareTo(end) <= 0) {
                    split.add(new Range(from, to));
                    from = to;
                }
            }
            ranges.clear();
            ranges.addAll(split);
        }
    }

    private org.openvpms.component.business.domain.im.common.Entity getScheduleEntity(long id) {
        org.openvpms.component.business.domain.im.common.Entity schedule = (org.openvpms.component.business.domain.im.common.Entity)this.service.get("party.organisationSchedule", id);
        if (schedule == null || !schedule.isActive() || !this.onlineBookingEnabled(schedule)) {
            throw new NotFoundException("Schedule not found");
        }
        return schedule;
    }

    private boolean onlineBookingEnabled(org.openvpms.component.business.domain.im.common.Entity schedule) {
        IMObjectBean bean = this.service.getBean((IMObject)schedule);
        return bean.getBoolean("onlineBooking");
    }
}

