/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.booking.impl;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.NotFoundException;
import org.openvpms.archetype.rules.workflow.AppointmentRules;
import org.openvpms.booking.api.LocationService;
import org.openvpms.booking.domain.Location;
import org.openvpms.booking.domain.Schedule;
import org.openvpms.booking.domain.User;
import org.openvpms.booking.impl.BookingLocations;
import org.openvpms.booking.impl.BookingUsers;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IMObjectQueryIterator;
import org.springframework.stereotype.Component;

@Component
public class LocationServiceImpl
implements LocationService {
    private final IArchetypeService service;
    private final BookingLocations locations;
    private final BookingUsers users;
    private final AppointmentRules appointmentRules;

    public LocationServiceImpl(IArchetypeService service, BookingLocations locations, BookingUsers users, AppointmentRules appointmentRules) {
        this.service = service;
        this.locations = locations;
        this.users = users;
        this.appointmentRules = appointmentRules;
    }

    @Override
    public List<Location> getLocations() {
        ArrayList<Location> result = new ArrayList<Location>();
        String timeZone = this.locations.getTimeZone().getID();
        for (Party location : this.locations.getLocations()) {
            result.add(new Location(location.getId(), location.getName(), timeZone));
        }
        return result;
    }

    @Override
    public Location getLocation(long locationId) {
        Party location = this.getLocationEntity(locationId);
        String timeZone = this.locations.getTimeZone().getID();
        return new Location(location.getId(), location.getName(), timeZone);
    }

    @Override
    public List<Schedule> getSchedules(long locationId) {
        ArrayList<Schedule> result = new ArrayList<Schedule>();
        Party location = this.getLocationEntity(locationId);
        ArchetypeQuery query = new ArchetypeQuery("party.organisationSchedule", true);
        query.add((IConstraint)Constraints.join((String)"location").add((IConstraint)Constraints.eq((String)"target", (Object)location)));
        IMObjectQueryIterator iterator = new IMObjectQueryIterator(this.service, (IArchetypeQuery)query);
        while (iterator.hasNext()) {
            IMObject schedule = (IMObject)iterator.next();
            IMObjectBean bean = this.service.getBean(schedule);
            if (!bean.getBoolean("onlineBooking")) continue;
            int slotSize = this.appointmentRules.getSlotSize((Entity)((Party)schedule));
            result.add(new Schedule(schedule.getId(), schedule.getName(), slotSize));
        }
        return result;
    }

    @Override
    public List<User> getUsers(long locationId) {
        ArrayList<User> result = new ArrayList<User>();
        Party location = this.getLocationEntity(locationId);
        for (IMObject iMObject : this.users.getUsers(location)) {
            result.add(new User(iMObject.getId(), iMObject.getName()));
        }
        return result;
    }

    private Party getLocationEntity(long locationId) {
        Party location = this.locations.getLocation(locationId);
        if (location == null) {
            throw new NotFoundException("Practice location not found");
        }
        return location;
    }
}

