/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.booking.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.rules.workflow.AppointmentRules;
import org.openvpms.archetype.rules.workflow.AppointmentService;
import org.openvpms.archetype.rules.workflow.ScheduleTimes;
import org.openvpms.archetype.rules.workflow.roster.RosterService;
import org.openvpms.booking.domain.Range;
import org.openvpms.booking.domain.ScheduleRange;
import org.openvpms.booking.domain.UserFreeBusy;
import org.openvpms.booking.impl.AppointmentSchedule;
import org.openvpms.booking.impl.DateHelper;
import org.openvpms.booking.impl.ScheduleEntityRange;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;

public class BookingCalendar {
    private final ArchetypeService service;
    private final RosterService rosterService;
    private final AppointmentService appointmentService;
    private final AppointmentRules rules;

    public BookingCalendar(ArchetypeService service, RosterService rosterService, AppointmentService appointmentService, AppointmentRules rules) {
        this.service = service;
        this.rosterService = rosterService;
        this.appointmentService = appointmentService;
        this.rules = rules;
    }

    public List<ScheduleRange> getFree(User user, Party location, String from, String to) {
        ArrayList<ScheduleRange> free = new ArrayList<ScheduleRange>();
        this.query(location, user, from, to, free, null);
        return free;
    }

    public List<ScheduleRange> getBusy(User user, Party location, String from, String to) {
        ArrayList<ScheduleRange> busy = new ArrayList<ScheduleRange>();
        this.query(location, user, from, to, null, busy);
        return busy;
    }

    public UserFreeBusy getFreeBusy(User user, Party location, String from, String to) {
        ArrayList<ScheduleRange> free = new ArrayList<ScheduleRange>();
        ArrayList<ScheduleRange> busy = new ArrayList<ScheduleRange>();
        this.query(location, user, from, to, free, busy);
        return new UserFreeBusy(user.getId(), free, busy);
    }

    private void query(Party location, User user, String from, String to, List<ScheduleRange> free, List<ScheduleRange> busy) {
        Date fromTime = DateHelper.getDate("from", from);
        Date toTime = DateHelper.getDate("to", to);
        Map<Entity, List<ScheduleEntityRange>> roster = this.getRosterEvents(user, location, fromTime, toTime);
        ArrayList<ScheduleTimes> allAppointments = this.appointmentService.getAppointmentsForClinician(user, fromTime, toTime);
        allAppointments = new ArrayList<ScheduleTimes>(allAppointments);
        Collections.sort(allAppointments);
        HashMap<Entity, AppointmentSchedule> schedules = new HashMap<Entity, AppointmentSchedule>();
        Date date = fromTime;
        while (date.compareTo(toTime) < 0) {
            Date startTime = DateRules.getDate((Date)date);
            Date endTime = DateRules.getNextDate((Date)startTime);
            Date min = DateRules.max((Date)startTime, (Date)fromTime);
            Date max = DateRules.min((Date)endTime, (Date)toTime);
            this.query(date, min, max, allAppointments, roster, free, busy, schedules);
            date = DateRules.getDate((Date)date, (int)1, (DateUnits)DateUnits.DAYS);
        }
    }

    private void query(Date date, Date min, Date max, List<ScheduleTimes> allAppointments, Map<Entity, List<ScheduleEntityRange>> roster, List<ScheduleRange> free, List<ScheduleRange> busy, Map<Entity, AppointmentSchedule> schedules) {
        List<ScheduleRange> appointments = this.getAppointments(date, allAppointments);
        for (Map.Entry<Entity, List<ScheduleEntityRange>> entry : roster.entrySet()) {
            List<ScheduleRange> events = this.getRoster(date, entry.getValue());
            AppointmentSchedule schedule = schedules.computeIfAbsent(entry.getKey(), entity -> new AppointmentSchedule((Entity)entity, this.service, this.rules));
            if (free != null && !events.isEmpty()) {
                Date scheduleEnd;
                Date scheduleStart = schedule.getStartTime(date);
                Date date2 = scheduleEnd = scheduleStart != null ? schedule.getEndTime(date) : null;
                if (scheduleStart != null && scheduleEnd != null) {
                    Date scheduleMin = DateRules.max((Date)min, (Date)scheduleStart);
                    Date scheduleMax = DateRules.min((Date)max, (Date)scheduleEnd);
                    List<ScheduleRange> slots = this.getFree(schedule.getId(), events, appointments, scheduleMin, scheduleMax);
                    free.addAll(slots);
                }
            }
            if (busy == null || appointments.isEmpty()) continue;
            busy.addAll(this.getBusy(schedule.getId(), appointments));
        }
    }

    private Map<Entity, List<ScheduleEntityRange>> getRosterEvents(User user, Party location, Date from, Date to) {
        List roster = this.rosterService.getUserEvents(user, location, from, to);
        LinkedHashMap<Entity, List<ScheduleEntityRange>> result = new LinkedHashMap<Entity, List<ScheduleEntityRange>>();
        for (RosterService.UserEvent event : roster) {
            for (Entity schedule : this.getSchedules(event.getArea())) {
                List list = result.computeIfAbsent(schedule, k -> new ArrayList());
                list.add(this.createRange(schedule, event.getStartTime(), event.getEndTime()));
            }
        }
        return result;
    }

    private List<Entity> getSchedules(Reference area) {
        List schedules = this.rosterService.getSchedules(area);
        if (schedules.size() > 1) {
            schedules.sort(Comparator.comparingLong(IMObject::getId));
        }
        return schedules;
    }

    private List<ScheduleRange> getAppointments(Date date, List<ScheduleTimes> allAppointments) {
        ArrayList<ScheduleRange> result = new ArrayList<ScheduleRange>();
        Date min = DateRules.getDate((Date)date);
        Date max = DateRules.getNextDate((Date)min);
        for (ScheduleTimes appointment : allAppointments) {
            this.addRange(result, appointment.getStartTime(), appointment.getEndTime(), min, max, appointment.getScheduleId());
        }
        return result;
    }

    private List<ScheduleRange> getFree(long scheduleId, List<ScheduleRange> events, List<ScheduleRange> appointments, Date min, Date max) {
        ArrayList<ScheduleRange> free = new ArrayList<ScheduleRange>();
        Date freeStart = null;
        Date freeEnd = null;
        for (ScheduleRange event : events) {
            Date eventStart = event.getStart();
            Date eventEnd = event.getEnd();
            if (freeStart == null || DateRules.compareTo((Date)eventStart, freeEnd) > 0) {
                if (freeStart != null) {
                    this.addRange(free, freeStart, freeEnd, min, max, scheduleId);
                }
                freeStart = eventStart;
                freeEnd = eventEnd;
                continue;
            }
            if (DateRules.compareTo((Date)eventEnd, (Date)freeEnd) <= 0) continue;
            freeEnd = eventEnd;
        }
        if (freeStart != null) {
            this.addRange(free, freeStart, freeEnd, min, max, scheduleId);
        }
        this.subtractAppointments(scheduleId, free, appointments);
        return free;
    }

    private void subtractAppointments(long scheduleId, List<ScheduleRange> free, List<ScheduleRange> appointments) {
        block0: for (Range range : appointments) {
            ListIterator<ScheduleRange> iterator = free.listIterator();
            Date appointmentStart = range.getStart();
            Date appointmentEnd = range.getEnd();
            while (iterator.hasNext()) {
                Range range2 = iterator.next();
                Date freeStart = range2.getStart();
                Date freeEnd = range2.getEnd();
                if (appointmentEnd.compareTo(freeStart) <= 0) continue block0;
                if (appointmentStart.compareTo(freeEnd) >= 0) continue;
                int startToStart = appointmentStart.compareTo(freeStart);
                int endToEnd = appointmentEnd.compareTo(freeEnd);
                if (startToStart <= 0 && endToEnd < 0) {
                    iterator.set(this.createRange(scheduleId, appointmentEnd, freeEnd));
                    continue;
                }
                if (startToStart <= 0) {
                    iterator.remove();
                    continue;
                }
                if (endToEnd < 0) {
                    iterator.set(this.createRange(scheduleId, freeStart, appointmentStart));
                    iterator.add(this.createRange(scheduleId, appointmentEnd, freeEnd));
                    continue;
                }
                iterator.set(this.createRange(scheduleId, freeStart, appointmentStart));
            }
        }
    }

    private List<ScheduleRange> getBusy(long scheduleId, List<ScheduleRange> appointments) {
        List<ScheduleRange> busy = new ArrayList<ScheduleRange>();
        boolean modified = false;
        for (ScheduleRange appointment : appointments) {
            ScheduleRange range;
            if (appointment.getSchedule() != scheduleId) continue;
            ListIterator<ScheduleRange> iterator = busy.listIterator();
            Date appointmentStart = appointment.getStart();
            Date appointmentEnd = appointment.getEnd();
            boolean found = false;
            while (iterator.hasNext()) {
                Date busyEnd;
                range = iterator.next();
                Date busyStart = range.getStart();
                if (!DateRules.intersects((Date)appointmentStart, (Date)appointmentEnd, (Date)busyStart, (Date)(busyEnd = range.getEnd()))) continue;
                iterator.set(this.createRange(range.getSchedule(), DateRules.min((Date)appointmentStart, (Date)busyStart), DateRules.max((Date)appointmentEnd, (Date)busyEnd)));
                found = true;
                modified = true;
            }
            if (found) continue;
            range = this.createRange(scheduleId, appointmentStart, appointmentEnd);
            int index = Collections.binarySearch(busy, range, (o1, o2) -> DateRules.compareTo((Date)o1.getStart(), (Date)o2.getStart()));
            if (index < 0) {
                index = -index - 1;
            }
            busy.add(index, range);
            modified = true;
        }
        if (modified) {
            busy = this.mergeRanges(scheduleId, busy);
        }
        return busy;
    }

    private List<ScheduleRange> mergeRanges(long scheduleId, List<ScheduleRange> ranges) {
        ArrayList<ScheduleRange> merged = new ArrayList<ScheduleRange>();
        Date start = null;
        Date end = null;
        for (ScheduleRange range : ranges) {
            if (start == null) {
                start = range.getStart();
                end = range.getEnd();
                continue;
            }
            if (end.compareTo(range.getStart()) >= 0) {
                end = DateRules.max((Date)range.getEnd(), (Date)end);
                continue;
            }
            merged.add(this.createRange(scheduleId, start, end));
            start = range.getStart();
            end = range.getEnd();
        }
        merged.add(this.createRange(scheduleId, start, end));
        return merged;
    }

    private List<ScheduleRange> getRoster(Date date, List<ScheduleEntityRange> events) {
        ArrayList<ScheduleRange> result = new ArrayList<ScheduleRange>();
        Date min = DateRules.getDate((Date)date);
        Date max = DateRules.getNextDate((Date)min);
        for (ScheduleRange scheduleRange : events) {
            this.addRange(result, scheduleRange.getStart(), scheduleRange.getEnd(), min, max, scheduleRange.getSchedule());
        }
        return result;
    }

    private void addRange(List<ScheduleRange> ranges, Date from, Date to, Date min, Date max, long schedule) {
        if (DateRules.compareTo((Date)to, (Date)min) >= 0) {
            if (DateRules.compareTo((Date)from, (Date)min) <= 0) {
                from = min;
            }
            if (DateRules.compareTo((Date)from, (Date)max) < 0) {
                if (DateRules.compareTo((Date)to, (Date)max) > 0) {
                    to = max;
                }
                if (from.compareTo(to) < 0) {
                    ranges.add(this.createRange(schedule, from, to));
                }
            }
        }
    }

    private ScheduleRange createRange(long schedule, Date from, Date to) {
        from = DateHelper.convert(from);
        to = DateHelper.convert(to);
        return new ScheduleRange(schedule, from, to);
    }

    private ScheduleEntityRange createRange(Entity schedule, Date from, Date to) {
        from = DateHelper.convert(from);
        to = DateHelper.convert(to);
        return new ScheduleEntityRange(schedule, from, to);
    }
}

