/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.booking.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.joda.time.DateTime;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.workflow.AppointmentRules;
import org.openvpms.booking.domain.AppointmentType;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;

class AppointmentSchedule {
    private final IMObjectBean bean;
    private final ArchetypeService service;
    private final AppointmentRules rules;
    private boolean initTimes = true;
    private IMObjectBean timesBean;

    public AppointmentSchedule(Entity schedule, ArchetypeService service, AppointmentRules rules) {
        this.bean = service.getBean((IMObject)schedule);
        this.service = service;
        this.rules = rules;
    }

    public long getId() {
        return this.bean.getObject().getId();
    }

    public List<AppointmentType> getAppointmentTypes() {
        ArrayList<AppointmentType> result = new ArrayList<AppointmentType>();
        for (IMObject relationship : this.bean.getValues("appointmentTypes")) {
            IMObjectBean relationshipBean = this.service.getBean(relationship);
            IMObject appointmentType = relationshipBean.getObject("target");
            if (appointmentType == null || !appointmentType.isActive()) continue;
            IMObjectBean appointmentTypeBean = this.service.getBean(appointmentType);
            int slots = relationshipBean.getInt("noSlots");
            if (!appointmentTypeBean.getBoolean("onlineBooking") || slots <= 0) continue;
            result.add(new AppointmentType(appointmentType.getId(), appointmentType.getName(), slots));
        }
        return result;
    }

    public Date getStartTime(Date date) {
        Date startTime;
        boolean open;
        IMObjectBean times = this.getOnlineBookingTimes();
        if (times != null) {
            String key = this.getNodePrefix(date);
            open = times.getBoolean(key + "Open");
            startTime = open ? times.getDate(key + "StartTime") : null;
        } else {
            open = true;
            startTime = this.bean.getDate("startTime");
        }
        if (open) {
            startTime = startTime == null ? date : DateRules.addDateTime((Date)date, (Date)startTime);
        }
        return startTime;
    }

    public Date getEndTime(Date date) {
        Date endTime;
        boolean open;
        IMObjectBean times = this.getOnlineBookingTimes();
        if (times != null) {
            String key = this.getNodePrefix(date);
            open = times.getBoolean(key + "Open");
            endTime = open ? times.getDate(key + "EndTime") : null;
        } else {
            open = true;
            endTime = this.bean.getDate("endTime");
        }
        if (open) {
            endTime = endTime != null ? DateRules.addDateTime((Date)date, (Date)endTime) : DateRules.getNextDate((Date)date);
        }
        return endTime;
    }

    public int getSlotSize() {
        return this.rules.getSlotSize(this.getSchedule());
    }

    public Entity getSchedule() {
        return (Entity)this.bean.getObject();
    }

    protected IMObjectBean getOnlineBookingTimes() {
        if (this.initTimes) {
            IMObject times = this.bean.getTarget("onlineBookingTimes");
            this.timesBean = times != null ? this.service.getBean(times) : null;
            this.initTimes = false;
        }
        return this.timesBean;
    }

    private String getNodePrefix(Date date) {
        String key;
        switch (new DateTime((Object)date).getDayOfWeek()) {
            case 1: {
                key = "mon";
                break;
            }
            case 2: {
                key = "tue";
                break;
            }
            case 3: {
                key = "wed";
                break;
            }
            case 4: {
                key = "thu";
                break;
            }
            case 5: {
                key = "fri";
                break;
            }
            case 6: {
                key = "sat";
                break;
            }
            default: {
                key = "sun";
            }
        }
        return key;
    }
}

