/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.booking.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openvpms.archetype.rules.user.UserQueryFactory;
import org.openvpms.booking.impl.BookingLocations;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IMObjectQueryIterator;

public class BookingUsers {
    private final IArchetypeService service;
    private final BookingLocations locations;

    public BookingUsers(IArchetypeService service, BookingLocations locations) {
        this.service = service;
        this.locations = locations;
    }

    public List<User> getUsers(Party location) {
        ArrayList<User> result = new ArrayList<User>();
        Iterator<User> iterator = this.queryUsers(location);
        while (iterator.hasNext()) {
            User user = iterator.next();
            if (!this.canBook(user)) continue;
            result.add(user);
        }
        return result;
    }

    public User getUser(long userId) {
        User result = null;
        IMObjectReference userRef = new IMObjectReference("security.user", userId);
        User user = (User)this.service.get((Reference)userRef, true);
        if (user != null && user.isActive() && this.canBook(user)) {
            result = user;
        }
        return result;
    }

    public List<Party> getLocations(User user) {
        List<Party> result;
        IMObjectBean bean = this.service.getBean((IMObject)user);
        List references = bean.getTargetRefs("locations");
        if (references.isEmpty()) {
            result = this.locations.getLocations();
        } else {
            result = new ArrayList<Party>();
            for (Reference reference : references) {
                Party location = this.locations.getLocation(reference.getId());
                if (location == null) continue;
                result.add(location);
            }
        }
        return result;
    }

    public Party getLocation(User user, long locationId) {
        Party result = null;
        IMObjectBean bean = this.service.getBean((IMObject)user);
        List references = bean.getTargetRefs("locations");
        if (references.isEmpty()) {
            result = this.locations.getLocation(locationId);
        } else {
            for (Reference reference : references) {
                if (reference.getId() != locationId) continue;
                result = this.locations.getLocation(locationId);
                break;
            }
        }
        return result;
    }

    protected Iterator<User> queryUsers(Party location) {
        ArchetypeQuery query = UserQueryFactory.createUserQuery((Party)location, (String[])new String[]{"name", "id"});
        return new IMObjectQueryIterator(this.service, (IArchetypeQuery)query);
    }

    private boolean canBook(User user) {
        return this.service.getBean((IMObject)user).getBoolean("onlineBooking");
    }
}

