/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.booking.impl;

import java.sql.Timestamp;
import java.util.Date;
import javax.ws.rs.BadRequestException;
import org.joda.time.DateTime;
import org.joda.time.format.ISODateTimeFormat;

class DateHelper {
    private DateHelper() {
    }

    static Date getDate(String name, String value) {
        DateTime result;
        if (value == null) {
            throw new BadRequestException("Missing '" + name + "' parameter");
        }
        try {
            result = ISODateTimeFormat.dateTimeNoMillis().parseDateTime(value);
        }
        catch (IllegalArgumentException e) {
            try {
                result = ISODateTimeFormat.dateTime().parseDateTime(value);
            }
            catch (IllegalArgumentException nested) {
                throw new BadRequestException("Parameter '" + name + "' is not a valid ISO date/time: " + value);
            }
        }
        return result.toDate();
    }

    static Date convert(Date date) {
        return date instanceof Timestamp ? new Date(date.getTime()) : date;
    }
}

