/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.booking.impl;

import java.net.URI;
import java.util.Date;
import java.util.Iterator;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.Period;
import org.openvpms.archetype.rules.party.Contacts;
import org.openvpms.archetype.rules.user.UserRules;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.workflow.AppointmentRules;
import org.openvpms.archetype.rules.workflow.Times;
import org.openvpms.booking.api.BookingService;
import org.openvpms.booking.domain.Booking;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.customer.Customer;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.domain.party.Email;
import org.openvpms.domain.party.Phone;
import org.openvpms.domain.patient.Patient;
import org.openvpms.domain.query.Filter;
import org.openvpms.domain.service.customer.CustomerQuery;
import org.openvpms.domain.service.customer.Customers;
import org.openvpms.domain.service.patient.PatientQuery;
import org.openvpms.domain.service.patient.Patients;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

@Component
public class BookingServiceImpl
implements BookingService {
    private final ArchetypeService service;
    private final Customers customers;
    private final Patients patients;
    private final DomainService domainService;
    private final Contacts contacts;
    private final AppointmentRules appointmentRules;
    private final UserRules userRules;
    private final PlatformTransactionManager transactionManager;
    private static final String INVALID_BOOKING_REFERENCE = "Invalid booking reference";

    public BookingServiceImpl(IArchetypeService service, Customers customers, Patients patients, DomainService domainService, AppointmentRules appointmentRules, UserRules userRules, PlatformTransactionManager transactionManager) {
        this.service = service;
        this.customers = customers;
        this.patients = patients;
        this.domainService = domainService;
        this.contacts = new Contacts((ArchetypeService)service);
        this.appointmentRules = appointmentRules;
        this.userRules = userRules;
        this.transactionManager = transactionManager;
    }

    @Override
    public Response create(Booking booking, UriInfo uriInfo) {
        if (booking == null) {
            throw new BadRequestException("Booking is required");
        }
        Date start = this.getRequired("start", booking.getStart());
        Date end = this.getRequired("end", booking.getEnd());
        this.checkBookingDates(start, end);
        Entity schedule = this.getSchedule(booking);
        Entity appointmentType = this.getAppointmentType(booking);
        this.checkBookingSlot(start, end, schedule);
        StringBuilder notes = new StringBuilder();
        Customer customer = this.getCustomer(booking);
        Patient patient = null;
        if (customer == null) {
            this.addNewCustomerNotes(booking, notes);
        } else {
            patient = this.getPatient(customer, booking);
        }
        if (patient == null && !StringUtils.isEmpty((CharSequence)booking.getPatientName())) {
            this.append(notes, "Patient", booking.getPatientName());
        }
        User user = this.getUser(booking);
        Act act = this.create(booking, start, end, schedule, appointmentType, notes, (Party)customer, (Party)patient, user);
        String reference = act.getId() + ":" + act.getLinkId();
        UriBuilder builder = uriInfo.getAbsolutePathBuilder();
        builder.path(reference);
        return Response.created((URI)builder.build(new Object[0])).type("text/plain").entity((Object)reference).build();
    }

    @Override
    public Response cancel(String reference) {
        Act act = this.getAppointment(reference);
        if (!"PENDING".equals(act.getStatus())) {
            throw new BadRequestException("The booking must be pending to cancel");
        }
        act.setStatus("CANCELLED");
        this.service.save((IMObject)act);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @Override
    public Booking getBooking(String reference) {
        Party patient;
        if (reference == null) {
            throw new BadRequestException(INVALID_BOOKING_REFERENCE);
        }
        Act act = this.getAppointment(reference);
        IMObjectBean bean = this.service.getBean((IMObject)act);
        Entity schedule = (Entity)bean.getTarget("schedule", Entity.class);
        Party customer = (Party)bean.getTarget("customer", Party.class);
        Reference appointmentType = bean.getTargetRef("appointmentType");
        Reference clinician = bean.getTargetRef("clinician");
        Booking booking = new Booking();
        if (schedule != null) {
            IMObjectBean scheduleBean = this.service.getBean((IMObject)schedule);
            booking.setSchedule(schedule.getId());
            Reference location = scheduleBean.getTargetRef("location");
            if (location != null) {
                booking.setLocation(location.getId());
            }
        }
        booking.setStart(act.getActivityStartTime());
        booking.setEnd(act.getActivityEndTime());
        if (customer != null) {
            Customer c = (Customer)this.domainService.create((IMObject)customer, Customer.class);
            booking.setTitle(c.getTitleCode());
            booking.setFirstName(c.getFirstName());
            booking.setLastName(c.getLastName());
            booking.setMobile(this.getPhone(c.getMobilePhone()));
            booking.setPhone(this.getPhone(c.getPhone()));
            booking.setEmail(this.getEmail(c.getEmail()));
        }
        if (appointmentType != null) {
            booking.setAppointmentType(appointmentType.getId());
        }
        if ((patient = (Party)bean.getTarget("patient", Party.class)) != null) {
            booking.setPatientName(patient.getName());
        }
        if (clinician != null) {
            booking.setUser(clinician.getId());
        }
        return booking;
    }

    protected void save(final Act act, final Entity schedule) {
        TransactionTemplate template = new TransactionTemplate(this.transactionManager);
        template.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                Times existing = BookingServiceImpl.this.appointmentRules.getOverlap(act.getActivityStartTime(), act.getActivityEndTime(), schedule);
                if (existing != null) {
                    throw new BadRequestException("An appointment is already scheduled for " + existing.getStartTime() + "-" + existing.getEndTime());
                }
                BookingServiceImpl.this.service.save((IMObject)act);
            }
        });
    }

    private Act create(Booking booking, Date start, Date end, Entity schedule, Entity appointmentType, StringBuilder notes, Party customer, Party patient, User user) {
        Date date;
        Period noReminderPeriod;
        String bookingNotes;
        Act act = (Act)this.service.create("act.customerAppointment", Act.class);
        IMObjectBean bean = this.service.getBean((IMObject)act);
        bean.setValue("startTime", (Object)start);
        bean.setValue("endTime", (Object)end);
        bean.setTarget("schedule", (IMObject)schedule);
        if (customer != null) {
            bean.setTarget("customer", (IMObject)customer);
        }
        bean.setTarget("appointmentType", (IMObject)appointmentType);
        String reason = this.getReason(appointmentType);
        if (reason != null) {
            bean.setValue("reason", (Object)reason);
        }
        if (patient != null) {
            bean.setTarget("patient", (IMObject)patient);
        }
        if (user != null) {
            if (this.userRules.isClinician(user)) {
                bean.setTarget("clinician", (IMObject)user);
            } else {
                this.append(notes, "User", user.getName());
            }
        }
        bean.setValue("onlineBooking", (Object)true);
        if (!StringUtils.isEmpty((CharSequence)booking.getNotes())) {
            this.append(notes, "Notes", booking.getNotes());
        }
        if (!(bookingNotes = StringUtils.abbreviate((String)notes.toString(), (int)5000)).isEmpty()) {
            bean.setValue("bookingNotes", (Object)bookingNotes);
        }
        if (customer != null && this.appointmentRules.isRemindersEnabled(schedule) && this.appointmentRules.isRemindersEnabled(appointmentType) && this.contacts.canSMS(customer) && (noReminderPeriod = this.appointmentRules.getNoReminderPeriod()) != null && start.after(date = DateRules.plus((Date)new Date(), (Period)noReminderPeriod))) {
            bean.setValue("sendReminder", (Object)true);
        }
        this.save(act, schedule);
        return act;
    }

    private String getReason(Entity appointmentType) {
        IMObjectBean bean = this.service.getBean((IMObject)appointmentType);
        Lookup reason = (Lookup)bean.getObject("reason", Lookup.class);
        return reason != null ? reason.getCode() : null;
    }

    private void addNewCustomerNotes(Booking booking, StringBuilder notes) {
        if (!StringUtils.isEmpty((CharSequence)booking.getTitle())) {
            this.append(notes, "Title", booking.getTitle());
        }
        this.append(notes, "First Name", booking.getFirstName());
        this.append(notes, "Last Name", booking.getLastName());
        if (!StringUtils.isEmpty((CharSequence)booking.getPhone())) {
            this.append(notes, "Phone", booking.getPhone());
        }
        if (!StringUtils.isEmpty((CharSequence)booking.getMobile())) {
            this.append(notes, "Mobile", booking.getMobile());
        }
        if (!StringUtils.isEmpty((CharSequence)booking.getEmail())) {
            this.append(notes, "Email", booking.getEmail());
        }
    }

    private void checkBookingDates(Date start, Date end) {
        Date now = new Date();
        if (start.compareTo(now) <= 0) {
            throw new BadRequestException("Cannot make a booking in the past");
        }
        if (end.compareTo(start) <= 0) {
            throw new BadRequestException("Booking start must be less than end");
        }
    }

    private void checkBookingSlot(Date start, Date end, Entity schedule) {
        int slotSize = this.appointmentRules.getSlotSize(schedule);
        Date slotStart = this.appointmentRules.getSlotTime(start, slotSize, false);
        if (slotStart.compareTo(start) != 0) {
            throw new BadRequestException("Booking start is not on a slot boundary");
        }
        Date slotEnd = this.appointmentRules.getSlotTime(end, slotSize, true);
        if (slotEnd.compareTo(end) != 0) {
            throw new BadRequestException("Booking end is not on a slot boundary");
        }
    }

    private void checkAvailable(IMObjectBean bean) {
        IMObject object = bean.getObject();
        if (!object.isActive() || !bean.getBoolean("onlineBooking")) {
            throw new BadRequestException(object.getName() + " is not available for booking");
        }
    }

    private Act getAppointment(String reference) {
        long appointmentId;
        String[] parts = reference.split(":");
        if (parts.length != 2) {
            throw new BadRequestException(INVALID_BOOKING_REFERENCE);
        }
        try {
            appointmentId = Long.parseLong(parts[0]);
        }
        catch (NumberFormatException exception) {
            throw new BadRequestException(INVALID_BOOKING_REFERENCE);
        }
        Act act = (Act)this.service.get("act.customerAppointment", appointmentId);
        if (act == null || !act.getLinkId().equals(parts[1]) || "CANCELLED".equals(act.getStatus())) {
            throw new NotFoundException("Booking not found");
        }
        return act;
    }

    private Entity getSchedule(Booking booking) {
        Entity schedule = this.getRequired("Schedule", booking.getSchedule(), "party.organisationSchedule");
        IMObjectBean bean = this.service.getBean((IMObject)schedule);
        this.checkAvailable(bean);
        Party location = (Party)bean.getTarget("location", Party.class);
        if (location == null || location.getId() != booking.getLocation()) {
            throw new BadRequestException("Schedule is not available at location " + booking.getLocation());
        }
        this.checkAvailable(this.service.getBean((IMObject)location));
        return schedule;
    }

    private Customer getCustomer(Booking booking) {
        String lastName;
        String firstName = this.getRequired("firstName", booking.getFirstName());
        Match match = this.getMatchOnFirstAndLastName(booking, firstName, lastName = this.getRequired("lastName", booking.getLastName()));
        if (match.getCustomer() == null && !match.isDuplicate()) {
            match = this.getMatchOnLastName(booking, lastName);
        }
        return match.getCustomer();
    }

    private Match getMatchOnFirstAndLastName(Booking booking, String firstName, String lastName) {
        CustomerQuery query = this.newCustomerQuery().name(lastName, firstName);
        return this.getCustomer(query, booking, 1);
    }

    private Match getMatchOnLastName(Booking booking, String lastName) {
        CustomerQuery query = this.newCustomerQuery().name(Filter.equal((Object)lastName), null);
        return this.getCustomer(query, booking, 2);
    }

    private Match getCustomer(CustomerQuery query, Booking booking, int count) {
        Match result = null;
        for (Customer customer : query.query()) {
            if (!this.matchesContacts(customer, booking, count)) continue;
            if (result != null) {
                result = Match.duplicate();
                break;
            }
            result = Match.match(customer);
        }
        return result != null ? result : Match.none();
    }

    private CustomerQuery newCustomerQuery() {
        return (CustomerQuery)((CustomerQuery)this.customers.getQuery().active()).orderById();
    }

    private Patient getPatient(Customer customer, Booking booking) {
        Patient match;
        block0: {
            Patient patient;
            Iterable matches;
            Iterator iterator;
            match = null;
            String name = StringUtils.trimToNull((String)booking.getPatientName());
            if (name == null || !(iterator = (matches = ((PatientQuery)((PatientQuery)((PatientQuery)this.patients.getQuery().name(name)).owner(customer).active()).orderById()).query()).iterator()).hasNext()) break block0;
            match = patient = (Patient)iterator.next();
        }
        return match;
    }

    private boolean matchesContacts(Customer customer, Booking booking, int count) {
        int match;
        block2: {
            Email email;
            String address;
            Phone phone;
            String number;
            match = 0;
            String bookingPhone = Contacts.getPhone((String)booking.getPhone());
            String bookingMobile = Contacts.getPhone((String)booking.getMobile());
            String bookingEmail = StringUtils.trimToNull((String)booking.getEmail());
            Iterator iterator = customer.getPhones().iterator();
            while (iterator.hasNext() && ((number = (phone = (Phone)iterator.next()).getPhoneNumber()) == null || !number.equals(bookingPhone) && !number.equals(bookingMobile) || ++match < count)) {
            }
            if (match >= count || bookingEmail == null) break block2;
            iterator = customer.getEmails().iterator();
            while (iterator.hasNext() && ((address = (email = (Email)iterator.next()).getEmailAddress()) == null || !address.equalsIgnoreCase(bookingEmail) || ++match < count)) {
            }
        }
        return match >= count;
    }

    private Entity getAppointmentType(Booking booking) {
        return this.getRequired("Appointment Type", booking.getAppointmentType(), "entity.appointmentType");
    }

    private User getUser(Booking booking) {
        long userId = booking.getUser();
        return userId > 0L ? (User)this.getRequired("User", userId, "security.user") : null;
    }

    private void append(StringBuilder notes, String key, String value) {
        if (notes.length() != 0) {
            notes.append('\n');
        }
        notes.append(key).append(": ").append(value);
    }

    private Entity getRequired(String name, long id, String archetype) {
        Entity result = (Entity)this.service.get(archetype, id, Entity.class);
        if (result == null) {
            throw new BadRequestException(name + " not found: " + id);
        }
        return result;
    }

    private Date getRequired(String name, Date value) {
        if (value == null) {
            throw new BadRequestException("'" + name + "' is a required field");
        }
        return value;
    }

    private String getRequired(String name, String value) {
        if ((value = StringUtils.trimToNull((String)value)) == null) {
            throw new BadRequestException("'" + name + "' is a required field");
        }
        return value;
    }

    private String getPhone(Phone phone) {
        String result = phone != null ? phone.getPhoneNumber() : null;
        return result != null ? result : "";
    }

    private String getEmail(Email email) {
        String result = email != null ? email.getEmailAddress() : null;
        return result != null ? result : "";
    }

    private static class Match {
        private final Customer customer;
        private final boolean duplicate;

        private Match() {
            this.customer = null;
            this.duplicate = true;
        }

        private Match(Customer customer) {
            this.customer = customer;
            this.duplicate = false;
        }

        public boolean isDuplicate() {
            return this.duplicate;
        }

        public Customer getCustomer() {
            return this.customer;
        }

        public static Match match(Customer customer) {
            return new Match(customer);
        }

        public static Match duplicate() {
            return new Match();
        }

        public static Match none() {
            return new Match(null);
        }
    }
}

