/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.booking.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;

public class BookingLocations {
    private final IArchetypeService service;
    private final PracticeService practiceService;

    public BookingLocations(IArchetypeService service, PracticeService practiceService) {
        this.service = service;
        this.practiceService = practiceService;
    }

    public List<Party> getLocations() {
        ArrayList<Party> result = new ArrayList<Party>();
        for (Party location : this.practiceService.getLocations()) {
            if (!this.canBook(location)) continue;
            result.add(location);
        }
        return result;
    }

    public Party getLocation(long locationId) {
        Party result = null;
        for (Party location : this.practiceService.getLocations()) {
            if (location.getId() != locationId) continue;
            result = this.canBook(location) ? location : null;
            break;
        }
        return result;
    }

    public TimeZone getTimeZone() {
        return TimeZone.getDefault();
    }

    private boolean canBook(Party location) {
        return location.isActive() && this.service.getBean((IMObject)location).getBoolean("onlineBooking");
    }
}

