/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.billing.internal.charge;

import java.util.Date;
import org.openvpms.archetype.rules.patient.reminder.ReminderRules;
import org.openvpms.billing.internal.charge.BuilderServices;
import org.openvpms.billing.internal.charge.InvoiceContext;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.patient.Patient;

class ReminderBuilder {
    private final BuilderServices services;
    private Patient patient;
    private Entity reminderType;
    private Relationship productReminder;
    private Product product;
    private Date date;
    private Date dueDate;
    private User clinician;
    private IMObjectBean invoiceItem;

    public ReminderBuilder(BuilderServices services) {
        this.services = services;
    }

    public Patient getPatient() {
        return this.patient;
    }

    public ReminderBuilder patient(Patient patient) {
        this.patient = patient;
        return this;
    }

    public Entity getReminderType() {
        return this.reminderType;
    }

    public ReminderBuilder reminderType(Entity reminderType, Relationship productReminder) {
        this.reminderType = reminderType;
        this.productReminder = productReminder;
        return this;
    }

    public ReminderBuilder date(Date date) {
        this.date = date;
        return this;
    }

    public Product getProduct() {
        return this.product;
    }

    public ReminderBuilder product(Product product) {
        this.product = product;
        return this;
    }

    public ReminderBuilder clinician(User clinician) {
        this.clinician = clinician;
        return this;
    }

    public ReminderBuilder invoiceItem(IMObjectBean bean) {
        this.invoiceItem = bean;
        return this;
    }

    public void build(InvoiceContext context) {
        ArchetypeService service = this.services.getArchetypeService();
        Act reminder = (Act)service.create("act.patientReminder", Act.class);
        IMObjectBean reminderBean = service.getBean((IMObject)reminder);
        reminderBean.setValue("initialTime", (Object)this.date);
        reminderBean.setTarget("patient", (IMObject)this.patient);
        reminderBean.setTarget("reminderType", (IMObject)this.reminderType);
        reminderBean.setTarget("product", (IMObject)this.product);
        reminderBean.setTarget("clinician", (IMObject)this.clinician);
        Date dueDate = this.getDueDate();
        reminder.setActivityEndTime(dueDate);
        ReminderRules rules = this.services.getReminderRules();
        Date next = rules.getNextReminderDate(dueDate, this.reminderType, 0);
        if (next == null) {
            next = dueDate;
        }
        reminder.setActivityStartTime(next);
        this.invoiceItem.addTarget("reminders", (IMObject)reminder, "invoiceItem");
        context.addReminder(reminder);
    }

    public Date getDueDate() {
        if (this.dueDate == null) {
            this.dueDate = this.services.getReminderRules().calculateProductReminderDueDate(this.date, this.productReminder);
        }
        return this.dueDate;
    }
}

