/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.billing.internal.charge;

import org.openvpms.archetype.rules.finance.discount.DiscountRules;
import org.openvpms.archetype.rules.practice.LocationRules;
import org.openvpms.archetype.rules.practice.PracticeRules;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.archetype.rules.product.ProductPriceRules;
import org.openvpms.archetype.rules.product.ServiceRatioService;
import org.openvpms.billing.internal.charge.PricingContext;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.party.Party;

public class PricingContextFactory {
    private final PracticeService practiceService;
    private final PracticeRules practiceRules;
    private final ProductPriceRules priceRules;
    private final DiscountRules discountRules;
    private final LocationRules locationRules;
    private final ServiceRatioService serviceRatios;
    private final IArchetypeService service;

    public PricingContextFactory(PracticeService practiceService, PracticeRules practiceRules, LocationRules locationRules, ProductPriceRules priceRules, DiscountRules discountRules, ServiceRatioService serviceRatios, IArchetypeService service) {
        this.practiceService = practiceService;
        this.practiceRules = practiceRules;
        this.priceRules = priceRules;
        this.locationRules = locationRules;
        this.discountRules = discountRules;
        this.serviceRatios = serviceRatios;
        this.service = service;
    }

    public Party getPractice() {
        return this.practiceService.getPractice();
    }

    public boolean useLocationProducts(Party practice) {
        return this.practiceRules.useLocationProducts(practice);
    }

    public PricingContext createContext(Party practice, Party location) {
        return new PricingContext(practice, location, this.practiceRules, this.priceRules, this.discountRules, this.locationRules, this.serviceRatios, this.service);
    }
}

