/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.billing.internal.charge;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.openvpms.billing.charge.InvoiceObjects;
import org.openvpms.billing.internal.charge.InvoiceContext;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.domain.customer.transaction.Invoice;
import org.openvpms.domain.customer.transaction.InvoiceItem;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.domain.patient.Patient;
import org.openvpms.domain.patient.record.Visit;

class InvoiceObjectsImpl
implements InvoiceObjects {
    private final InvoiceContext context;
    private final DomainService domainService;

    public InvoiceObjectsImpl(InvoiceContext context, DomainService domainService) {
        this.context = context;
        this.domainService = domainService;
    }

    public Invoice getCharge() {
        return (Invoice)this.domainService.create(this.context.getCharge(), Invoice.class);
    }

    public List<InvoiceItem> getItems() {
        return this.context.getChanges("act.customerAccountInvoiceItem").stream().map(object -> (InvoiceItem)this.domainService.create(object, InvoiceItem.class)).collect(Collectors.toList());
    }

    public List<Visit> getVisits() {
        return this.context.getVisits().stream().map(object -> (Visit)this.domainService.create((IMObject)object, Visit.class)).collect(Collectors.toList());
    }

    public Optional<Visit> getVisit(Patient patient) {
        Act act = this.context.getVisit(patient);
        return act != null ? Optional.of(this.domainService.create((IMObject)act, Visit.class)) : Optional.empty();
    }
}

