/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.billing.internal.charge;

import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.openvpms.archetype.rules.patient.reminder.ReminderRules;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.billing.charge.InvoiceBuilder;
import org.openvpms.billing.charge.InvoiceItemBuilder;
import org.openvpms.billing.internal.charge.AlertBuilder;
import org.openvpms.billing.internal.charge.BuildContext;
import org.openvpms.billing.internal.charge.BuilderServices;
import org.openvpms.billing.internal.charge.ChargeItemBuilderImpl;
import org.openvpms.billing.internal.charge.InvoiceBuilderImpl;
import org.openvpms.billing.internal.charge.InvoiceContext;
import org.openvpms.billing.internal.charge.ReminderBuilder;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.user.User;
import org.openvpms.domain.customer.transaction.Invoice;
import org.openvpms.domain.customer.transaction.InvoiceItem;
import org.openvpms.domain.product.Batch;
import org.openvpms.domain.product.Medication;

public class InvoiceItemBuilderImpl
extends ChargeItemBuilderImpl<Invoice, InvoiceItem, InvoiceBuilder, InvoiceItemBuilder>
implements InvoiceItemBuilder {
    private Batch batch;
    private static final String PATIENT = "patient";
    private static final String PRODUCT = "product";
    private static final String QUANTITY = "quantity";
    private static final String BATCH = "batch";
    private static final String CLINICIAN = "clinician";
    private static final String DISPENSING = "dispensing";
    private static final String INVOICE_ITEM = "invoiceItem";
    private static final String BATCH_EXPIRY = "endTime";

    public InvoiceItemBuilderImpl(InvoiceBuilderImpl parent, BuilderServices services) {
        super("act.customerAccountInvoiceItem", parent, services);
    }

    public Batch getBatch() {
        return this.batch;
    }

    public InvoiceItemBuilder batch(Batch batch) {
        this.batch = batch;
        return this;
    }

    @Override
    protected void build(FinancialAct act, IMObjectBean bean, Date date, BuildContext context) {
        super.build(act, bean, date, context);
        Product product = this.getProduct();
        if (this.batch != null) {
            bean.setTarget(BATCH, (IMObject)this.batch);
        }
        InvoiceContext invoiceContext = (InvoiceContext)context;
        if (product instanceof Medication) {
            this.buildMedication(act, bean, (Medication)product, date, invoiceContext);
        } else {
            invoiceContext.addRecord((Act)act, date);
        }
        this.generateReminders(bean, date);
        this.generateAlerts(bean, date);
    }

    protected InvoiceBuilderImpl getParent() {
        return (InvoiceBuilderImpl)super.getParent();
    }

    private void buildMedication(FinancialAct act, IMObjectBean bean, Medication product, Date date, InvoiceContext invoiceContext) {
        Act medication = this.create("act.patientMedication", Act.class);
        IMObjectBean medicationBean = this.getBean((IMObject)medication);
        medicationBean.setTarget(PATIENT, (IMObject)this.getPatient());
        medicationBean.setTarget(PRODUCT, (IMObject)product);
        if (this.batch != null) {
            medicationBean.setTarget(BATCH, (IMObject)this.batch);
            OffsetDateTime expiry = this.batch.getExpiry();
            medicationBean.setValue(BATCH_EXPIRY, (Object)DateRules.toDate((OffsetDateTime)expiry));
        }
        medicationBean.setValue(QUANTITY, (Object)this.getQuantity());
        medicationBean.setValue("label", (Object)product.getLabelInstructions());
        User clinician = this.getClinician();
        if (clinician != null) {
            medicationBean.setTarget(CLINICIAN, (IMObject)clinician);
        }
        bean.addTarget(DISPENSING, (IMObject)medication, INVOICE_ITEM);
        invoiceContext.addRecord(medication, act, date);
    }

    private void generateReminders(IMObjectBean bean, Date date) {
        Map<Entity, Relationship> reminderTypes = this.getReminderTypes();
        for (Map.Entry<Entity, Relationship> entry : reminderTypes.entrySet()) {
            ReminderBuilder builder = new ReminderBuilder(this.getServices()).patient(this.getPatient()).reminderType(entry.getKey(), entry.getValue()).date(date).product(this.getProduct()).clinician(this.getClinician()).invoiceItem(bean);
            this.getParent().addReminder(builder);
        }
    }

    private Map<Entity, Relationship> getReminderTypes() {
        ReminderRules rules = this.getServices().getReminderRules();
        String species = this.getPatient().getSpeciesCode();
        return rules.getReminderTypes(this.getProduct(), species);
    }

    private void generateAlerts(IMObjectBean bean, Date date) {
        for (Entity alertType : this.getAlertTypes()) {
            AlertBuilder builder = new AlertBuilder(this.getServices()).patient(this.getPatient()).alertType(alertType).date(date).product(this.getProduct()).clinician(this.getClinician()).invoiceItem(bean);
            this.getParent().addAlert(builder);
        }
    }

    private List<Entity> getAlertTypes() {
        IMObjectBean bean = this.getBean((IMObject)this.getProduct());
        return bean.hasNode("alerts") ? bean.getTargets("alerts", Entity.class) : Collections.emptyList();
    }
}

