/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.billing.internal.charge;

import java.math.BigDecimal;
import java.util.Date;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.archetype.rules.product.ProductPriceRules;
import org.openvpms.billing.internal.charge.PricingContext;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.product.ProductPrice;
import org.openvpms.domain.customer.Customer;
import org.openvpms.domain.patient.Patient;

class ChargeAmounts {
    private final BigDecimal serviceRatio;
    private final BigDecimal fixedCost;
    private final BigDecimal fixedPrice;
    private final BigDecimal unitCost;
    private final BigDecimal unitPrice;
    private final BigDecimal discount;
    private final BigDecimal total;
    private final BigDecimal tax;

    public ChargeAmounts(Customer customer, Patient patient, Product product, BigDecimal quantity, Date date, PricingContext context) {
        this.serviceRatio = context.getServiceRatio(product, date);
        ProductPrice fixedProductPrice = context.getFixedPrice(product, date);
        this.fixedCost = this.getCost(fixedProductPrice, context);
        this.fixedPrice = this.getPrice(product, customer, fixedProductPrice, this.serviceRatio, context);
        ProductPrice unitProductPrice = context.getUnitPrice(product, date);
        this.unitCost = this.getCost(unitProductPrice, context);
        this.unitPrice = this.getPrice(product, customer, unitProductPrice, this.serviceRatio, context);
        BigDecimal maxFixedPriceDiscount = this.getMaxDiscount(fixedProductPrice, context);
        BigDecimal maxUnitPriceDiscount = this.getMaxDiscount(unitProductPrice, context);
        this.discount = context.getDiscount((Party)customer, (Party)patient, product, this.fixedCost, this.fixedPrice, maxFixedPriceDiscount, this.unitCost, this.unitPrice, maxUnitPriceDiscount, quantity, date);
        this.total = MathRules.calculateTotal((BigDecimal)this.fixedPrice, (BigDecimal)this.unitPrice, (BigDecimal)quantity, (BigDecimal)this.discount, (int)2);
        this.tax = context.getTax(this.total, product, (Party)customer);
    }

    public BigDecimal getServiceRatio() {
        return this.serviceRatio;
    }

    public BigDecimal getFixedCost() {
        return this.fixedCost;
    }

    public BigDecimal getFixedPrice() {
        return this.fixedPrice;
    }

    public BigDecimal getUnitCost() {
        return this.unitCost;
    }

    public BigDecimal getUnitPrice() {
        return this.unitPrice;
    }

    public BigDecimal getDiscount() {
        return this.discount;
    }

    public BigDecimal getTotal() {
        return this.total;
    }

    public BigDecimal getTax() {
        return this.tax;
    }

    private BigDecimal getCost(ProductPrice price, PricingContext context) {
        return price != null ? context.getCost(price) : BigDecimal.ZERO;
    }

    private BigDecimal getPrice(Product product, Customer customer, ProductPrice productPrice, BigDecimal serviceRatio, PricingContext context) {
        BigDecimal result = BigDecimal.ZERO;
        if (productPrice != null) {
            result = context.getPrice(product, (Party)customer, productPrice, serviceRatio);
        }
        return result;
    }

    private BigDecimal getMaxDiscount(ProductPrice price, PricingContext context) {
        return price != null ? context.getMaxDiscount(price) : ProductPriceRules.DEFAULT_MAX_DISCOUNT;
    }
}

