/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.billing.internal.charge;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.openvpms.billing.internal.charge.PricingContext;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;

class BuildContext {
    private final IMObjectBean charge;
    private final Set<IMObject> changes = new LinkedHashSet<IMObject>();
    private final PricingContext pricingContext;
    private final ArchetypeService service;

    public BuildContext(IMObjectBean charge, PricingContext pricingContext, ArchetypeService service) {
        this.charge = charge;
        this.pricingContext = pricingContext;
        this.service = service;
    }

    public IMObjectBean getCharge() {
        return this.charge;
    }

    public void addChange(IMObject object) {
        this.changes.add(object);
    }

    public void save() {
        this.service.save(this.changes);
    }

    public PricingContext getPricingContext() {
        return this.pricingContext;
    }

    public List<IMObject> getChanges(String archetype) {
        return this.changes.stream().filter(object -> object.isA(archetype)).collect(Collectors.toList());
    }

    protected ArchetypeService getService() {
        return this.service;
    }
}

