/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.billing.internal.service;

import java.math.BigDecimal;
import org.openvpms.billing.charge.InvoiceBuilder;
import org.openvpms.billing.charge.InvoiceItemBuilder;
import org.openvpms.billing.internal.charge.BuilderServices;
import org.openvpms.billing.internal.charge.InvoiceBuilderImpl;
import org.openvpms.billing.service.BillingService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.user.User;
import org.openvpms.domain.customer.Customer;
import org.openvpms.domain.customer.transaction.Invoice;
import org.openvpms.domain.internal.query.IdQuery;
import org.openvpms.domain.patient.Patient;
import org.openvpms.domain.practice.Location;

public class BillingServiceImpl
implements BillingService {
    private final BuilderServices services;
    private final IdQuery query;

    public BillingServiceImpl(BuilderServices services) {
        this.services = services;
        this.query = new IdQuery(services.getArchetypeService());
    }

    public Invoice getInvoice(long id) {
        return (Invoice)this.services.getDomainService().get("act.customerAccountChargesInvoice", id, Invoice.class);
    }

    public Invoice getInvoice(String archetype, String id) {
        Act act = (Act)this.query.getObject("act.customerAccountChargesInvoice", Act.class, archetype, id);
        return act != null ? (Invoice)this.services.getDomainService().create((IMObject)act, Invoice.class) : null;
    }

    public long getInvoiceId(String archetype, String id) {
        Long result = this.query.getId("act.customerAccountChargesInvoice", Act.class, archetype, id);
        return result != null ? result : -1L;
    }

    public Invoice invoice(Customer customer, Patient patient, Product product, BigDecimal quantity, Location location, User clinician) {
        return (Invoice)((InvoiceBuilder)((InvoiceItemBuilder)((InvoiceItemBuilder)((InvoiceItemBuilder)((InvoiceItemBuilder)((InvoiceItemBuilder)((InvoiceBuilder)((InvoiceBuilder)((InvoiceBuilder)this.getInvoiceBuilder().customer(customer)).clinician(clinician)).location(location)).newItem()).patient(patient)).product(product)).quantity(quantity)).clinician(clinician)).add()).build();
    }

    public InvoiceBuilder getInvoiceBuilder() {
        return new InvoiceBuilderImpl(this.services);
    }
}

