/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.billing.internal.charge;

import java.math.BigDecimal;
import java.util.Objects;
import org.openvpms.component.model.product.Product;

public class ProductQuantity {
    private final Product product;
    private final boolean zeroPrice;
    private final boolean print;
    private BigDecimal lowQuantity;
    private BigDecimal highQuantity;

    public ProductQuantity(Product product, BigDecimal lowQuantity, BigDecimal highQuantity, boolean zeroPrice, boolean print) {
        this.product = product;
        this.lowQuantity = lowQuantity;
        this.highQuantity = highQuantity;
        this.zeroPrice = zeroPrice;
        this.print = print;
    }

    public Product getProduct() {
        return this.product;
    }

    public BigDecimal getLowQuantity() {
        return this.lowQuantity;
    }

    public BigDecimal getHighQuantity() {
        return this.highQuantity;
    }

    public void add(BigDecimal lowQuantity, BigDecimal highQuantity) {
        this.lowQuantity = this.lowQuantity.add(lowQuantity);
        this.highQuantity = this.highQuantity.add(highQuantity);
    }

    public boolean getZeroPrice() {
        return this.zeroPrice;
    }

    public boolean getPrint() {
        return this.print;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ProductQuantity) {
            ProductQuantity other = (ProductQuantity)obj;
            return Objects.equals(this.product, other.product) && this.zeroPrice == other.zeroPrice;
        }
        return false;
    }

    public int hashCode() {
        return this.product.hashCode();
    }
}

