/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.billing.internal.charge;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.openvpms.archetype.rules.patient.PatientHistoryChanges;
import org.openvpms.archetype.rules.patient.reminder.ReminderRules;
import org.openvpms.billing.internal.charge.BuildContext;
import org.openvpms.billing.internal.charge.PricingContext;
import org.openvpms.component.business.service.archetype.functor.ActComparator;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.patient.Patient;

class InvoiceContext
extends BuildContext {
    private final ReminderRules reminderRules;
    private final PatientHistoryChanges historyChanges;
    private final List<Act> reminders = new ArrayList<Act>();
    private final List<Act> alerts = new ArrayList<Act>();

    public InvoiceContext(IMObjectBean charge, PricingContext pricingContext, ArchetypeService service, ReminderRules reminderRules) {
        super(charge, pricingContext, service);
        this.reminderRules = reminderRules;
        this.historyChanges = new PatientHistoryChanges(pricingContext.getLocation(), service);
    }

    @Override
    public void addChange(IMObject object) {
        super.addChange(object);
    }

    public void addRecord(Act record, FinancialAct item, Date date) {
        this.addChange((IMObject)record);
        this.historyChanges.addToEvents(Arrays.asList(record, item), date);
    }

    public void addRecord(Act record, Date date) {
        this.addChange((IMObject)record);
        this.historyChanges.addToEvents(Collections.singletonList(record), date);
    }

    public void addReminder(Act reminder) {
        this.reminders.add(reminder);
        this.addChange((IMObject)reminder);
    }

    public void addAlert(Act alert) {
        this.alerts.add(alert);
        this.addChange((IMObject)alert);
    }

    @Override
    public void save() {
        super.save();
        this.historyChanges.save();
        if (!this.reminders.isEmpty()) {
            this.reminderRules.markMatchingRemindersCompleted(this.reminders);
        }
        if (!this.alerts.isEmpty()) {
            this.reminderRules.markMatchingAlertsCompleted(this.alerts);
        }
    }

    public Act getVisit(Patient patient) {
        Act result = null;
        List visits = this.historyChanges.getEvents(patient.getObjectReference());
        if (visits.size() > 1) {
            visits.sort(ActComparator.descending());
        }
        if (!visits.isEmpty()) {
            result = (Act)visits.get(0);
        }
        return result;
    }

    public List<Act> getVisits() {
        return this.historyChanges.getEvents();
    }
}

