/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.billing.internal.charge;

import java.util.Date;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.billing.internal.charge.BuilderServices;
import org.openvpms.billing.internal.charge.InvoiceContext;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.patient.Patient;

class AlertBuilder {
    private final BuilderServices services;
    private Patient patient;
    private Entity alertType;
    private Product product;
    private Date date;
    private User clinician;
    private IMObjectBean invoiceItem;

    public AlertBuilder(BuilderServices services) {
        this.services = services;
    }

    public Patient getPatient() {
        return this.patient;
    }

    public AlertBuilder patient(Patient patient) {
        this.patient = patient;
        return this;
    }

    public Entity getAlertType() {
        return this.alertType;
    }

    public AlertBuilder alertType(Entity alertType) {
        this.alertType = alertType;
        return this;
    }

    public AlertBuilder date(Date date) {
        this.date = date;
        return this;
    }

    public Product getProduct() {
        return this.product;
    }

    public AlertBuilder product(Product product) {
        this.product = product;
        return this;
    }

    public AlertBuilder clinician(User clinician) {
        this.clinician = clinician;
        return this;
    }

    public AlertBuilder invoiceItem(IMObjectBean bean) {
        this.invoiceItem = bean;
        return this;
    }

    public void build(InvoiceContext context) {
        ArchetypeService service = this.services.getArchetypeService();
        Act alert = (Act)service.create("act.patientAlert", Act.class);
        IMObjectBean bean = service.getBean((IMObject)alert);
        bean.setTarget("patient", (IMObject)this.patient);
        bean.setTarget("alertType", (IMObject)this.alertType);
        bean.setTarget("product", (IMObject)this.product);
        bean.setTarget("clinician", (IMObject)this.clinician);
        IMObjectBean alertTypeBean = service.getBean((IMObject)this.alertType);
        alert.setReason(alertTypeBean.getString("reason"));
        Date endTime = null;
        int duration = alertTypeBean.getInt("duration");
        String units = alertTypeBean.getString("durationUnits");
        if (duration > 0 && units != null) {
            endTime = DateRules.getDate((Date)this.date, (int)duration, (DateUnits)DateUnits.valueOf((String)units));
        }
        alert.setActivityStartTime(this.date);
        alert.setActivityEndTime(endTime);
        this.invoiceItem.addTarget("alerts", (IMObject)alert, "invoiceItem");
        context.addAlert(alert);
    }
}

